/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.socket.handler;

import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import org.miaixz.bus.socket.TcpAioSession;
import org.miaixz.bus.socket.handler.ReadCompletionHandler;

public class ConcurrentReadCompletionHandler
extends ReadCompletionHandler {
    private final Semaphore semaphore;
    private final ThreadLocal<ConcurrentReadCompletionHandler> threadLocal = new ThreadLocal();
    private final ThreadPoolExecutor threadPoolExecutor;

    public ConcurrentReadCompletionHandler(Semaphore semaphore, ThreadPoolExecutor threadPoolExecutor) {
        this.semaphore = semaphore;
        this.threadPoolExecutor = threadPoolExecutor;
    }

    @Override
    public void completed(Integer result, TcpAioSession aioSession) {
        if (this.threadLocal.get() != null) {
            super.completed(result, aioSession);
            return;
        }
        if (this.semaphore.tryAcquire()) {
            Runnable task;
            this.threadLocal.set(this);
            super.completed(result, aioSession);
            while ((task = (Runnable)this.threadPoolExecutor.getQueue().poll()) != null) {
                task.run();
            }
            this.semaphore.release();
            this.threadLocal.set(null);
            return;
        }
        this.threadPoolExecutor.execute(() -> ConcurrentReadCompletionHandler.super.completed(result, aioSession));
    }
}

