/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.socket.handler;

import java.nio.channels.CompletionHandler;
import org.miaixz.bus.socket.NetMonitor;
import org.miaixz.bus.socket.SocketStatus;
import org.miaixz.bus.socket.TcpAioSession;

public class ReadCompletionHandler
implements CompletionHandler<Integer, TcpAioSession> {
    @Override
    public void completed(Integer result, TcpAioSession aioSession) {
        try {
            if (result == -2) {
                aioSession.suspendRead();
                return;
            }
            if (result == -3) {
                aioSession.doRead();
                return;
            }
            NetMonitor monitor = aioSession.getServerConfig().getMonitor();
            if (monitor != null) {
                monitor.afterRead(aioSession, result);
            }
            aioSession.flipRead(result == -1);
            aioSession.signalRead();
        }
        catch (Exception e) {
            this.failed((Throwable)e, aioSession);
        }
    }

    @Override
    public final void failed(Throwable exc, TcpAioSession aioSession) {
        try {
            aioSession.getServerConfig().getProcessor().stateEvent(aioSession, SocketStatus.INPUT_EXCEPTION, exc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            aioSession.close(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

