/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.socket.plugins;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.socket.AioSession;
import org.miaixz.bus.socket.QuickTimer;
import org.miaixz.bus.socket.SocketStatus;
import org.miaixz.bus.socket.plugins.AbstractPlugin;

public final class MonitorPlugin<T>
extends AbstractPlugin<T>
implements Runnable {
    private final LongAdder inFlow = new LongAdder();
    private final LongAdder outFlow = new LongAdder();
    private final LongAdder processFailNum = new LongAdder();
    private final LongAdder processMsgNum = new LongAdder();
    private final LongAdder newConnect = new LongAdder();
    private final LongAdder disConnect = new LongAdder();
    private final LongAdder readCount = new LongAdder();
    private final LongAdder writeCount = new LongAdder();
    private final int seconds;
    private long totalConnect;
    private long totalProcessMsgNum = 0L;
    private long onlineCount;
    private boolean udp;

    public MonitorPlugin() {
        this(60);
    }

    public MonitorPlugin(int seconds) {
        this(seconds, false);
    }

    public MonitorPlugin(int seconds, boolean udp) {
        this.seconds = seconds;
        this.udp = udp;
        long mills = TimeUnit.SECONDS.toMillis(seconds);
        QuickTimer.scheduleAtFixedRate(this, mills, mills);
    }

    @Override
    public boolean preProcess(AioSession session, T t) {
        this.processMsgNum.increment();
        return true;
    }

    @Override
    public void stateEvent(SocketStatus socketStatus, AioSession session, Throwable throwable) {
        switch (socketStatus) {
            case PROCESS_EXCEPTION: {
                this.processFailNum.increment();
                break;
            }
            case NEW_SESSION: {
                this.newConnect.increment();
                break;
            }
            case SESSION_CLOSED: {
                this.disConnect.increment();
                break;
            }
        }
    }

    @Override
    public void run() {
        long curInFlow = this.getAndReset(this.inFlow);
        long curOutFlow = this.getAndReset(this.outFlow);
        long curDiscardNum = this.getAndReset(this.processFailNum);
        long curProcessMsgNum = this.getAndReset(this.processMsgNum);
        long connectCount = this.getAndReset(this.newConnect);
        long disConnectCount = this.getAndReset(this.disConnect);
        long curReadCount = this.getAndReset(this.readCount);
        long curWriteCount = this.getAndReset(this.writeCount);
        this.onlineCount += connectCount - disConnectCount;
        this.totalProcessMsgNum += curProcessMsgNum;
        this.totalConnect += connectCount;
        Logger.info((String)("\r\n-----" + this.seconds + "seconds ----\r\ninflow:\t\t" + (double)curInFlow * 1.0 / 1048576.0 + "(MB)\r\noutflow:\t" + (double)curOutFlow * 1.0 / 1048576.0 + "(MB)\r\nprocess fail:\t" + curDiscardNum + "\r\nprocess count:\t" + curProcessMsgNum + "\r\nprocess total:\t" + this.totalProcessMsgNum + "\r\nread count:\t" + curReadCount + "\twrite count:\t" + curWriteCount + (String)(this.udp ? "" : "\r\nconnect count:\t" + connectCount + "\r\ndisconnect count:\t" + disConnectCount + "\r\nonline count:\t" + this.onlineCount + "\r\nconnected total:\t" + this.totalConnect) + "\r\nRequests/sec:\t" + (double)curProcessMsgNum * 1.0 / (double)this.seconds + "\r\nTransfer/sec:\t" + (double)curInFlow * 1.0 / 1048576.0 / (double)this.seconds + "(MB)"), (Object[])new Object[0]);
    }

    private long getAndReset(LongAdder longAdder) {
        long result = longAdder.longValue();
        longAdder.add(-result);
        return result;
    }

    @Override
    public void afterRead(AioSession session, int readSize) {
        if (readSize == 0) {
            Logger.error((String)"readSize is 0", (Object[])new Object[0]);
        }
        this.inFlow.add(readSize);
    }

    @Override
    public void beforeRead(AioSession session) {
        this.readCount.increment();
    }

    @Override
    public void afterWrite(AioSession session, int writeSize) {
        this.outFlow.add(writeSize);
    }

    @Override
    public void beforeWrite(AioSession session) {
        this.writeCount.increment();
    }
}

