/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.socket.process;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.miaixz.bus.socket.AioSession;
import org.miaixz.bus.socket.GroupIo;
import org.miaixz.bus.socket.process.MessageProcessor;

public abstract class GroupMessageProcessor<T>
implements MessageProcessor<T>,
GroupIo {
    private Map<String, GroupUnit> sessionGroup = new ConcurrentHashMap<String, GroupUnit>();

    @Override
    public final synchronized void join(String group, AioSession session) {
        GroupUnit groupUnit = this.sessionGroup.get(group);
        if (null == groupUnit) {
            groupUnit = new GroupUnit(this);
            this.sessionGroup.put(group, groupUnit);
        }
        groupUnit.groupList.add(session);
    }

    @Override
    public final synchronized void remove(String group, AioSession session) {
        GroupUnit groupUnit = this.sessionGroup.get(group);
        if (null == groupUnit) {
            return;
        }
        groupUnit.groupList.remove(session);
        if (groupUnit.groupList.isEmpty()) {
            this.sessionGroup.remove(group);
        }
    }

    @Override
    public final void remove(AioSession session) {
        for (String group : this.sessionGroup.keySet()) {
            this.remove(group, session);
        }
    }

    @Override
    public void writeToGroup(String group, byte[] t) {
        GroupUnit groupUnit = this.sessionGroup.get(group);
        for (AioSession aioSession : groupUnit.groupList) {
            try {
                aioSession.writeBuffer().write(t);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private class GroupUnit {
        Set<AioSession> groupList = new HashSet<AioSession>();

        private GroupUnit(GroupMessageProcessor groupMessageProcessor) {
        }
    }
}

