/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.socket;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.socket.Context;
import org.miaixz.bus.socket.Monitor;
import org.miaixz.bus.socket.Status;
import org.miaixz.bus.socket.accord.UdpChannel;
import org.miaixz.bus.socket.accord.UdpSession;
import org.miaixz.bus.socket.buffer.BufferPage;
import org.miaixz.bus.socket.buffer.BufferPagePool;
import org.miaixz.bus.socket.buffer.VirtualBuffer;

public final class Worker
implements Runnable {
    private static final Runnable SELECTOR_CHANNEL = () -> {};
    private static final Runnable SHUTDOWN_CHANNEL = () -> {};
    private final Selector selector;
    private BufferPagePool writeBufferPool = null;
    private BufferPage readBufferPage = null;
    private final BlockingQueue<Runnable> requestQueue = new ArrayBlockingQueue<Runnable>(256);
    private final ConcurrentLinkedQueue<Consumer<Selector>> registers = new ConcurrentLinkedQueue();
    private final ExecutorService executorService;
    private VirtualBuffer standbyBuffer;

    public Worker(BufferPagePool writeBufferPool, int threadNum) throws IOException {
        this(writeBufferPool.allocateBufferPage(), writeBufferPool, threadNum);
    }

    public Worker(BufferPage readBufferPage, BufferPagePool writeBufferPool, int threadNum) throws IOException {
        this.readBufferPage = readBufferPage;
        this.writeBufferPool = writeBufferPool;
        this.selector = Selector.open();
        try {
            this.requestQueue.put(SELECTOR_CHANNEL);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.executorService = new ThreadPoolExecutor(threadNum, threadNum, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            int i = 0;

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "smart-socket:udp-" + Worker.this.hashCode() + "-" + ++this.i);
            }
        });
        for (int i = 0; i < threadNum; ++i) {
            this.executorService.execute(this);
        }
    }

    public void addRegister(Consumer<Selector> register) {
        this.registers.offer(register);
        this.selector.wakeup();
    }

    @Override
    public void run() {
        try {
            while (true) {
                Runnable runnable;
                if ((runnable = this.requestQueue.take()) == SHUTDOWN_CHANNEL) {
                    this.requestQueue.put(SHUTDOWN_CHANNEL);
                    this.selector.wakeup();
                    break;
                }
                if (runnable == SELECTOR_CHANNEL) {
                    try {
                        this.doSelector();
                    }
                    finally {
                        this.requestQueue.put(SELECTOR_CHANNEL);
                    }
                    continue;
                }
                runnable.run();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doSelector() throws IOException {
        Consumer<Selector> register;
        while ((register = this.registers.poll()) != null) {
            register.accept(this.selector);
        }
        Set<SelectionKey> keySet = this.selector.selectedKeys();
        if (keySet.isEmpty()) {
            this.selector.select();
        }
        Iterator<SelectionKey> keyIterator = keySet.iterator();
        while (keyIterator.hasNext()) {
            SelectionKey key = keyIterator.next();
            UdpChannel udpChannel = (UdpChannel)key.attachment();
            if (!key.isValid()) {
                keyIterator.remove();
                udpChannel.close();
                continue;
            }
            if (key.isWritable()) {
                udpChannel.doWrite();
            }
            if (key.isReadable() && !this.doRead(udpChannel)) break;
            keyIterator.remove();
        }
    }

    public boolean doRead(UdpChannel channel) throws IOException {
        int count = 16;
        Context context = channel.context;
        while (count-- > 0) {
            if (this.standbyBuffer == null) {
                this.standbyBuffer = this.readBufferPage.allocate(context.getReadBufferSize());
            }
            ByteBuffer buffer = this.standbyBuffer.buffer();
            SocketAddress remote = channel.getChannel().receive(buffer);
            if (remote == null) {
                buffer.clear();
                return true;
            }
            VirtualBuffer readyBuffer = this.standbyBuffer;
            this.standbyBuffer = this.readBufferPage.allocate(context.getReadBufferSize());
            buffer.flip();
            Runnable runnable = () -> {
                UdpSession session = new UdpSession(channel, remote, this.writeBufferPool.allocateBufferPage());
                try {
                    Monitor monitor = context.getMonitor();
                    if (monitor != null) {
                        monitor.beforeRead(session);
                        monitor.afterRead(session, buffer.remaining());
                    }
                    do {
                        Object request;
                        if ((request = context.getProtocol().decode(buffer, session)) == null) {
                            context.getProcessor().stateEvent(session, Status.DECODE_EXCEPTION, (Throwable)new InternalException("decode result is null, buffer size: " + buffer.remaining()));
                            break;
                        }
                        context.getProcessor().process(session, request);
                    } while (buffer.hasRemaining());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    context.getProcessor().stateEvent(session, Status.DECODE_EXCEPTION, e);
                }
                finally {
                    session.writeBuffer().flush();
                    readyBuffer.clean();
                }
            };
            if (this.requestQueue.offer(runnable)) continue;
            return false;
        }
        return true;
    }

    public void shutdown() {
        try {
            this.requestQueue.put(SHUTDOWN_CHANNEL);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.selector.wakeup();
        this.executorService.shutdown();
        try {
            this.selector.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

