/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.socket.accord;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.socket.Context;
import org.miaixz.bus.socket.Handler;
import org.miaixz.bus.socket.Message;
import org.miaixz.bus.socket.Session;
import org.miaixz.bus.socket.accord.TcpSession;
import org.miaixz.bus.socket.buffer.BufferPagePool;
import org.miaixz.bus.socket.metric.channels.AsynchronousChannelProvider;

public final class AioClient {
    private static final ScheduledExecutorService CONNECT_TIMEOUT_EXECUTOR = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread thread = new Thread(r, "connection-timeout-monitor");
        thread.setDaemon(true);
        return thread;
    });
    private final Context context = new Context();
    private TcpSession session;
    private AsynchronousChannelGroup asynchronousChannelGroup;
    private SocketAddress localAddress;
    private int connectTimeout;
    private BufferPagePool writeBufferPool = null;
    private BufferPagePool readBufferPool = null;
    private boolean lowMemory = true;

    public <T> AioClient(String host, int port, Message<T> message, Handler<T> handler) {
        this.context.setHost(host);
        this.context.setPort(port);
        this.context.setProtocol(message);
        this.context.setProcessor(handler);
    }

    public <A> void start(A attachment, CompletionHandler<Session, ? super A> handler) throws IOException {
        this.asynchronousChannelGroup = new AsynchronousChannelProvider(this.lowMemory).openAsynchronousChannelGroup(2, Thread::new);
        this.start(this.asynchronousChannelGroup, attachment, handler);
    }

    public <A> void start(AsynchronousChannelGroup asynchronousChannelGroup, final A attachment, final CompletionHandler<Session, ? super A> handler) throws IOException {
        AsynchronousSocketChannel socketChannel = AsynchronousSocketChannel.open(asynchronousChannelGroup);
        if (this.connectTimeout > 0) {
            CONNECT_TIMEOUT_EXECUTOR.schedule(() -> {
                if (this.session == null) {
                    IoKit.close((AsynchronousSocketChannel)socketChannel);
                    this.shutdownNow();
                }
            }, (long)this.connectTimeout, TimeUnit.MILLISECONDS);
        }
        if (this.writeBufferPool == null) {
            this.writeBufferPool = BufferPagePool.DEFAULT_BUFFER_PAGE_POOL;
        }
        if (this.readBufferPool == null) {
            this.readBufferPool = BufferPagePool.DEFAULT_BUFFER_PAGE_POOL;
        }
        if (this.context.getSocketOptions() != null) {
            for (Map.Entry<SocketOption<Object>, Object> entry : this.context.getSocketOptions().entrySet()) {
                socketChannel.setOption((SocketOption)entry.getKey(), entry.getValue());
            }
        }
        if (this.localAddress != null) {
            socketChannel.bind(this.localAddress);
        }
        socketChannel.connect(new InetSocketAddress(this.context.getHost(), this.context.getPort()), socketChannel, new CompletionHandler<Void, AsynchronousSocketChannel>(){

            @Override
            public void completed(Void result, AsynchronousSocketChannel socketChannel) {
                try {
                    AsynchronousSocketChannel connectedChannel = socketChannel;
                    if (AioClient.this.context.getMonitor() != null) {
                        connectedChannel = AioClient.this.context.getMonitor().shouldAccept(socketChannel);
                    }
                    if (connectedChannel == null) {
                        throw new RuntimeException("Monitor refuse channel");
                    }
                    AioClient.this.session = new TcpSession(connectedChannel, AioClient.this.context, AioClient.this.writeBufferPool.allocateBufferPage(), () -> AioClient.this.readBufferPool.allocateBufferPage().allocate(AioClient.this.context.getReadBufferSize()));
                    handler.completed(AioClient.this.session, attachment);
                }
                catch (Exception e) {
                    this.failed((Throwable)e, socketChannel);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void failed(Throwable exc, AsynchronousSocketChannel socketChannel) {
                try {
                    handler.failed(exc, attachment);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (socketChannel != null) {
                        IoKit.close((AsynchronousSocketChannel)socketChannel);
                    }
                    AioClient.this.shutdownNow();
                }
            }
        });
    }

    public Session start(AsynchronousChannelGroup asynchronousChannelGroup) throws IOException {
        CompletableFuture future = new CompletableFuture();
        this.start(asynchronousChannelGroup, future, new CompletionHandler<Session, CompletableFuture<Session>>(this){

            @Override
            public void completed(Session session, CompletableFuture<Session> future) {
                if (future.isDone() || future.isCancelled()) {
                    session.close();
                } else {
                    future.complete(session);
                }
            }

            @Override
            public void failed(Throwable exc, CompletableFuture<Session> future) {
                future.completeExceptionally(exc);
            }
        });
        try {
            return (Session)future.get();
        }
        catch (Exception e) {
            future.cancel(false);
            this.shutdownNow();
            throw new IOException(e.getCause() == null ? e : e.getCause());
        }
    }

    public TcpSession getSession() {
        return this.session;
    }

    public Session start() throws IOException {
        this.asynchronousChannelGroup = new AsynchronousChannelProvider(this.lowMemory).openAsynchronousChannelGroup(2, Thread::new);
        return this.start(this.asynchronousChannelGroup);
    }

    public void shutdown() {
        this.shutdown0(false);
    }

    public void shutdownNow() {
        this.shutdown0(true);
    }

    private synchronized void shutdown0(boolean flag) {
        if (this.session != null) {
            this.session.close(flag);
            this.session = null;
        }
        if (this.asynchronousChannelGroup != null) {
            this.asynchronousChannelGroup.shutdown();
            this.asynchronousChannelGroup = null;
        }
    }

    public AioClient setReadBufferSize(int size) {
        this.context.setReadBufferSize(size);
        return this;
    }

    public <V> AioClient setOption(SocketOption<V> socketOption, V value) {
        this.context.setOption(socketOption, value);
        return this;
    }

    public AioClient bindLocal(String local, int port) {
        this.localAddress = local == null ? new InetSocketAddress(port) : new InetSocketAddress(local, port);
        return this;
    }

    public AioClient setBufferPagePool(BufferPagePool bufferPool) {
        return this.setBufferPagePool(bufferPool, bufferPool);
    }

    public AioClient setBufferPagePool(BufferPagePool readBufferPool, BufferPagePool writeBufferPool) {
        this.writeBufferPool = writeBufferPool;
        this.readBufferPool = readBufferPool;
        return this;
    }

    public AioClient setWriteBuffer(int bufferSize, int bufferCapacity) {
        this.context.setWriteBufferSize(bufferSize);
        this.context.setWriteBufferCapacity(bufferCapacity);
        return this;
    }

    public AioClient connectTimeout(int timeout) {
        this.connectTimeout = timeout;
        return this;
    }

    public AioClient disableLowMemory() {
        this.lowMemory = false;
        return this;
    }
}

