/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.socket.buffer;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.miaixz.bus.socket.buffer.BufferPage;

public final class BufferPagePool {
    private static final ScheduledThreadPoolExecutor BUFFER_POOL_CLEAN = new ScheduledThreadPoolExecutor(1, r -> {
        Thread thread = new Thread(r, "BufferPoolClean");
        thread.setDaemon(true);
        return thread;
    });
    public static final BufferPagePool DEFAULT_BUFFER_PAGE_POOL = new BufferPagePool(0, 1, false);
    private final AtomicInteger cursor = new AtomicInteger(0);
    private BufferPage[] bufferPages;
    private boolean enabled = true;
    private final ScheduledFuture<?> future = BUFFER_POOL_CLEAN.scheduleWithFixedDelay(new Runnable(){

        @Override
        public void run() {
            if (BufferPagePool.this.enabled) {
                for (BufferPage bufferPage : BufferPagePool.this.bufferPages) {
                    bufferPage.tryClean();
                }
            } else {
                if (BufferPagePool.this.bufferPages != null) {
                    for (BufferPage page : BufferPagePool.this.bufferPages) {
                        page.release();
                    }
                    BufferPagePool.this.bufferPages = null;
                }
                BufferPagePool.this.future.cancel(false);
            }
        }
    }, 500L, 1000L, TimeUnit.MILLISECONDS);

    public BufferPagePool(int pageSize, int pageNum, boolean isDirect) {
        this.bufferPages = new BufferPage[pageNum];
        for (int i = 0; i < pageNum; ++i) {
            this.bufferPages[i] = new BufferPage(pageSize, isDirect);
        }
        if (pageNum == 0 || pageSize == 0) {
            this.future.cancel(false);
        }
    }

    public BufferPage allocateBufferPage() {
        if (this.enabled) {
            return this.bufferPages[(this.cursor.getAndIncrement() & Integer.MAX_VALUE) % this.bufferPages.length];
        }
        throw new IllegalStateException("buffer pool is disable");
    }

    public void release() {
        this.enabled = false;
    }
}

