/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.socket.metric.channels;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.miaixz.bus.socket.metric.channels.AsynchronousServerChannel;
import org.miaixz.bus.socket.metric.channels.AsynchronousServerSocketChannel;

class AsynchronousChannelGroup
extends java.nio.channels.AsynchronousChannelGroup {
    public static final int MAX_INVOKER = 8;
    final Worker commonWorker;
    final Worker writeWorker;
    private final ExecutorService readExecutorService;
    private final ExecutorService commonExecutorService;
    private final Worker[] readWorkers;
    private final AtomicInteger readIndex = new AtomicInteger(0);
    boolean running = true;

    protected AsynchronousChannelGroup(AsynchronousChannelProvider provider, ExecutorService readExecutorService, int threadNum) throws IOException {
        super(provider);
        this.readExecutorService = readExecutorService;
        this.readWorkers = new Worker[threadNum];
        for (int i = 0; i < threadNum; ++i) {
            this.readWorkers[i] = new Worker(Selector.open(), selectionKey -> {
                AsynchronousServerChannel asynchronousSocketChannel = (AsynchronousServerChannel)selectionKey.attachment();
                asynchronousSocketChannel.doRead(true);
            });
            this.readExecutorService.execute(this.readWorkers[i]);
        }
        this.writeWorker = new Worker(Selector.open(), selectionKey -> {
            AsynchronousServerChannel asynchronousSocketChannel = (AsynchronousServerChannel)selectionKey.attachment();
            if (this.running) {
                selectionKey.interestOps(selectionKey.interestOps() & 0xFFFFFFFB);
            }
            while (asynchronousSocketChannel.doWrite()) {
            }
        });
        this.commonWorker = new Worker(Selector.open(), selectionKey -> {
            if (selectionKey.isAcceptable()) {
                AsynchronousServerSocketChannel serverSocketChannel = (AsynchronousServerSocketChannel)selectionKey.attachment();
                serverSocketChannel.doAccept();
            } else if (selectionKey.isConnectable()) {
                Runnable runnable = (Runnable)selectionKey.attachment();
                runnable.run();
            } else if (selectionKey.isReadable()) {
                AsynchronousServerChannel asynchronousSocketChannel = (AsynchronousServerChannel)selectionKey.attachment();
                AsynchronousChannelGroup.removeOps(selectionKey, 1);
                asynchronousSocketChannel.doRead(true);
            } else {
                throw new IllegalStateException("unexpect callback,key valid:" + selectionKey.isValid() + " ,interestOps:" + selectionKey.interestOps());
            }
        });
        this.commonExecutorService = new ThreadPoolExecutor(2, 2, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), r -> new Thread(r, "Socket:common"));
        this.commonExecutorService.execute(this.writeWorker);
        this.commonExecutorService.execute(this.commonWorker);
    }

    public static void removeOps(SelectionKey selectionKey, int opt) {
        if (selectionKey.isValid() && (selectionKey.interestOps() & opt) != 0) {
            selectionKey.interestOps(selectionKey.interestOps() & ~opt);
        }
    }

    public static void interestOps(Worker worker, SelectionKey selectionKey, int opt) {
        if ((selectionKey.interestOps() & opt) != 0) {
            return;
        }
        selectionKey.interestOps(selectionKey.interestOps() | opt);
        if (worker.workerThread != Thread.currentThread()) {
            selectionKey.selector().wakeup();
        }
    }

    public Worker getReadWorker() {
        return this.readWorkers[(this.readIndex.getAndIncrement() & Integer.MAX_VALUE) % this.readWorkers.length];
    }

    @Override
    public boolean isShutdown() {
        return this.readExecutorService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.readExecutorService.isTerminated();
    }

    @Override
    public void shutdown() {
        this.running = false;
        this.commonWorker.workerThread.interrupt();
        this.writeWorker.workerThread.interrupt();
        for (Worker worker : this.readWorkers) {
            worker.workerThread.interrupt();
        }
        this.readExecutorService.shutdown();
        this.commonExecutorService.shutdown();
    }

    @Override
    public void shutdownNow() {
        this.shutdown();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.readExecutorService.awaitTermination(timeout, unit);
    }

    class Worker
    implements Runnable {
        final Selector selector;
        private final Consumer<SelectionKey> consumer;
        private final ConcurrentLinkedQueue<Consumer<Selector>> consumers = new ConcurrentLinkedQueue();
        private Thread workerThread;

        Worker(Selector selector, Consumer<SelectionKey> consumer) {
            this.selector = selector;
            this.consumer = consumer;
        }

        final void addRegister(Consumer<Selector> register) {
            this.consumers.offer(register);
            this.selector.wakeup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            this.workerThread = Thread.currentThread();
            Set<SelectionKey> keySet = this.selector.selectedKeys();
            try {
                while (AsynchronousChannelGroup.this.running) {
                    Consumer<Selector> selectorConsumer;
                    while ((selectorConsumer = this.consumers.poll()) != null) {
                        selectorConsumer.accept(this.selector);
                    }
                    this.selector.select();
                    for (SelectionKey key2 : keySet) {
                        this.consumer.accept(key2);
                    }
                    keySet.clear();
                }
                this.selector.keys().forEach(key -> {
                    try {
                        this.consumer.accept((SelectionKey)key);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    this.selector.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

