/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.socket.metric.handler;

import java.nio.channels.AsynchronousSocketChannel;
import java.util.ArrayList;
import java.util.List;
import org.miaixz.bus.socket.Handler;
import org.miaixz.bus.socket.Monitor;
import org.miaixz.bus.socket.Plugin;
import org.miaixz.bus.socket.Session;
import org.miaixz.bus.socket.Status;

public abstract class AbstractMessageHandler<T>
implements Handler<T>,
Monitor {
    private final List<Plugin<T>> plugins = new ArrayList<Plugin<T>>();

    @Override
    public final void afterRead(Session session, int readSize) {
        for (Plugin<T> plugin : this.plugins) {
            plugin.afterRead(session, readSize);
        }
    }

    @Override
    public final void afterWrite(Session session, int writeSize) {
        for (Plugin<T> plugin : this.plugins) {
            plugin.afterWrite(session, writeSize);
        }
    }

    @Override
    public final void beforeRead(Session session) {
        for (Plugin<T> plugin : this.plugins) {
            plugin.beforeRead(session);
        }
    }

    @Override
    public final void beforeWrite(Session session) {
        for (Plugin<T> plugin : this.plugins) {
            plugin.beforeWrite(session);
        }
    }

    @Override
    public final AsynchronousSocketChannel shouldAccept(AsynchronousSocketChannel channel) {
        AsynchronousSocketChannel acceptChannel = channel;
        for (Plugin<T> plugin : this.plugins) {
            acceptChannel = plugin.shouldAccept(acceptChannel);
            if (acceptChannel != null) continue;
            return null;
        }
        return acceptChannel;
    }

    @Override
    public final void process(Session session, T data) {
        boolean flag = true;
        for (Plugin<T> plugin : this.plugins) {
            if (plugin.process(session, data)) continue;
            flag = false;
        }
        if (flag) {
            this.process0(session, data);
        }
    }

    public abstract void process0(Session var1, T var2);

    @Override
    public final void stateEvent(Session session, Status status, Throwable throwable) {
        for (Plugin<T> plugin : this.plugins) {
            plugin.stateEvent(status, session, throwable);
        }
        this.stateEvent0(session, status, throwable);
    }

    public abstract void stateEvent0(Session var1, Status var2, Throwable var3);

    public final void addPlugin(Plugin<T> plugin) {
        this.plugins.add(plugin);
    }
}

