/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.socket.accord;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.security.InvalidParameterException;
import java.util.Map;
import java.util.function.Supplier;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.socket.Context;
import org.miaixz.bus.socket.Handler;
import org.miaixz.bus.socket.Message;
import org.miaixz.bus.socket.Session;
import org.miaixz.bus.socket.Status;
import org.miaixz.bus.socket.accord.TcpSession;
import org.miaixz.bus.socket.buffer.BufferPagePool;
import org.miaixz.bus.socket.buffer.VirtualBuffer;
import org.miaixz.bus.socket.metric.channels.AsynchronousChannelProvider;

public final class AioServer {
    private static long threadSeqNumber;
    private final Context context = new Context();
    private AsynchronousServerSocketChannel serverSocketChannel = null;
    private AsynchronousChannelGroup asynchronousChannelGroup;
    private boolean lowMemory = true;
    private BufferPagePool writeBufferPool = null;
    private BufferPagePool readBufferPool = null;

    public <T> AioServer(int port, Message<T> message, Handler<T> handler) {
        this.context.setPort(port);
        this.context.setProtocol(message);
        this.context.setProcessor(handler);
        this.context.setThreadNum(Runtime.getRuntime().availableProcessors());
    }

    public <T> AioServer(String host, int port, Message<T> message, Handler<T> handler) {
        this(port, message, handler);
        this.context.setHost(host);
    }

    public void start() throws IOException {
        this.asynchronousChannelGroup = new AsynchronousChannelProvider(this.lowMemory).openAsynchronousChannelGroup(this.context.getThreadNum(), r -> new Thread(r, "Socket:Thread-" + threadSeqNumber++));
        this.start(this.asynchronousChannelGroup);
    }

    public void start(AsynchronousChannelGroup asynchronousChannelGroup) throws IOException {
        try {
            if (this.writeBufferPool == null) {
                this.writeBufferPool = BufferPagePool.DEFAULT_BUFFER_PAGE_POOL;
            }
            if (this.readBufferPool == null) {
                this.readBufferPool = BufferPagePool.DEFAULT_BUFFER_PAGE_POOL;
            }
            this.serverSocketChannel = AsynchronousServerSocketChannel.open(asynchronousChannelGroup);
            if (this.context.getSocketOptions() != null) {
                for (Map.Entry<SocketOption<Object>, Object> entry : this.context.getSocketOptions().entrySet()) {
                    this.serverSocketChannel.setOption((SocketOption)entry.getKey(), entry.getValue());
                }
            }
            if (this.context.getHost() != null) {
                this.serverSocketChannel.bind(new InetSocketAddress(this.context.getHost(), this.context.getPort()), this.context.getBacklog());
            } else {
                this.serverSocketChannel.bind(new InetSocketAddress(this.context.getPort()), this.context.getBacklog());
            }
            this.startAcceptThread();
        }
        catch (IOException e) {
            this.shutdown();
            throw e;
        }
    }

    private void startAcceptThread() {
        final Supplier<VirtualBuffer> readBufferSupplier = () -> this.readBufferPool.allocateBufferPage().allocate(this.context.getReadBufferSize());
        this.serverSocketChannel.accept(null, new CompletionHandler<AsynchronousSocketChannel, Void>(){
            final /* synthetic */ AioServer this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void completed(AsynchronousSocketChannel channel, Void attachment) {
                try {
                    this.this$0.serverSocketChannel.accept(attachment, this);
                }
                catch (Throwable throwable) {
                    this.this$0.context.getProcessor().stateEvent(null, Status.ACCEPT_EXCEPTION, throwable);
                    this.failed(throwable, attachment);
                    this.this$0.serverSocketChannel.accept(attachment, this);
                }
                finally {
                    this.this$0.createSession(channel, readBufferSupplier);
                }
            }

            @Override
            public void failed(Throwable exc, Void attachment) {
                exc.printStackTrace();
            }
        });
    }

    private void createSession(AsynchronousSocketChannel channel, Supplier<VirtualBuffer> readBufferSupplier) {
        Session session = null;
        AsynchronousSocketChannel acceptChannel = channel;
        try {
            if (this.context.getMonitor() != null) {
                acceptChannel = this.context.getMonitor().shouldAccept(channel);
            }
            if (acceptChannel != null) {
                acceptChannel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
                session = new TcpSession(acceptChannel, this.context, this.writeBufferPool.allocateBufferPage(), readBufferSupplier);
            } else {
                this.context.getProcessor().stateEvent(null, Status.REJECT_ACCEPT, null);
                IoKit.close((AsynchronousSocketChannel)channel);
            }
        }
        catch (Exception e) {
            if (session == null) {
                IoKit.close((AsynchronousSocketChannel)channel);
            } else {
                session.close();
            }
            this.context.getProcessor().stateEvent(null, Status.INTERNAL_EXCEPTION, e);
        }
    }

    public void shutdown() {
        try {
            if (this.serverSocketChannel != null) {
                this.serverSocketChannel.close();
                this.serverSocketChannel = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.asynchronousChannelGroup != null) {
            this.asynchronousChannelGroup.shutdown();
        }
    }

    public AioServer setReadBufferSize(int size) {
        this.context.setReadBufferSize(size);
        return this;
    }

    public <V> AioServer setOption(SocketOption<V> socketOption, V value) {
        this.context.setOption(socketOption, value);
        return this;
    }

    public AioServer setThreadNum(int threadNum) {
        if (threadNum <= 1) {
            throw new InvalidParameterException("threadNum must >= 2");
        }
        this.context.setThreadNum(threadNum);
        return this;
    }

    public AioServer setWriteBuffer(int bufferSize, int bufferCapacity) {
        this.context.setWriteBufferSize(bufferSize);
        this.context.setWriteBufferCapacity(bufferCapacity);
        return this;
    }

    public final AioServer setBacklog(int backlog) {
        this.context.setBacklog(backlog);
        return this;
    }

    public AioServer setBufferPagePool(BufferPagePool bufferPool) {
        return this.setBufferPagePool(bufferPool, bufferPool);
    }

    public AioServer setBufferPagePool(BufferPagePool readBufferPool, BufferPagePool writeBufferPool) {
        this.writeBufferPool = writeBufferPool;
        this.readBufferPool = readBufferPool;
        return this;
    }

    public AioServer disableLowMemory() {
        this.lowMemory = false;
        return this;
    }
}

