/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.socket.metric.channels;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.ReadPendingException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritePendingException;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.miaixz.bus.socket.metric.channels.AsynchronousChannelGroup;
import org.miaixz.bus.socket.metric.handler.FutureCompletionHandler;

class AsynchronousServerChannel
extends AsynchronousSocketChannel {
    protected final SocketChannel channel;
    private final AsynchronousChannelGroup.Worker readWorker;
    private final boolean lowMemory;
    private final AsynchronousChannelGroup channelGroup;
    private ByteBuffer readBuffer;
    private ByteBuffer writeBuffer;
    private CompletionHandler<Number, Object> readCompletionHandler;
    private CompletionHandler<Number, Object> writeCompletionHandler;
    private Object readAttachment;
    private Object writeAttachment;
    private SelectionKey readSelectionKey;
    private boolean writeInterrupted;
    private byte readInvoker = (byte)8;

    public AsynchronousServerChannel(AsynchronousChannelGroup group, SocketChannel channel, boolean lowMemory) throws IOException {
        super(group.provider());
        this.channel = channel;
        this.channelGroup = group;
        this.readWorker = group.getReadWorker();
        this.lowMemory = lowMemory;
    }

    @Override
    public final void close() throws IOException {
        SelectionKey key;
        IOException exception = null;
        try {
            if (this.channel.isOpen()) {
                this.channel.close();
            }
        }
        catch (IOException e) {
            exception = e;
        }
        if (this.readCompletionHandler != null) {
            this.doRead(true);
        }
        if (this.readSelectionKey != null) {
            this.readSelectionKey.cancel();
            this.readSelectionKey = null;
        }
        if ((key = this.channel.keyFor(this.channelGroup.writeWorker.selector)) != null) {
            key.cancel();
        }
        if ((key = this.channel.keyFor(this.channelGroup.commonWorker.selector)) != null) {
            key.cancel();
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public final AsynchronousSocketChannel bind(SocketAddress local) throws IOException {
        this.channel.bind(local);
        return this;
    }

    @Override
    public final <T> AsynchronousSocketChannel setOption(SocketOption<T> name, T value) throws IOException {
        this.channel.setOption((SocketOption)name, (Object)value);
        return this;
    }

    @Override
    public final <T> T getOption(SocketOption<T> name) throws IOException {
        return this.channel.getOption(name);
    }

    @Override
    public final Set<SocketOption<?>> supportedOptions() {
        return this.channel.supportedOptions();
    }

    @Override
    public final AsynchronousSocketChannel shutdownInput() throws IOException {
        this.channel.shutdownInput();
        return this;
    }

    @Override
    public final AsynchronousSocketChannel shutdownOutput() throws IOException {
        this.channel.shutdownOutput();
        return this;
    }

    @Override
    public final SocketAddress getRemoteAddress() throws IOException {
        return this.channel.getRemoteAddress();
    }

    @Override
    public <A> void connect(SocketAddress remote, A attachment, CompletionHandler<Void, ? super A> handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<Void> connect(SocketAddress remote) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final <A> void read(ByteBuffer dst, long timeout, TimeUnit unit, A attachment, CompletionHandler<Integer, ? super A> handler) {
        if (timeout > 0L) {
            throw new UnsupportedOperationException();
        }
        this.read0(dst, attachment, handler);
    }

    private <V extends Number, A> void read0(ByteBuffer readBuffer, A attachment, CompletionHandler<V, ? super A> handler) {
        if (this.readCompletionHandler != null) {
            throw new ReadPendingException();
        }
        this.readBuffer = readBuffer;
        this.readAttachment = attachment;
        this.readCompletionHandler = handler;
        this.doRead(handler instanceof FutureCompletionHandler);
    }

    @Override
    public final Future<Integer> read(ByteBuffer readBuffer) {
        FutureCompletionHandler readFuture = new FutureCompletionHandler();
        this.read(readBuffer, 0L, TimeUnit.MILLISECONDS, null, readFuture);
        return readFuture;
    }

    @Override
    public final <A> void read(ByteBuffer[] dsts, int offset, int length, long timeout, TimeUnit unit, A attachment, CompletionHandler<Long, ? super A> handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final <A> void write(ByteBuffer src, long timeout, TimeUnit unit, A attachment, CompletionHandler<Integer, ? super A> handler) {
        if (timeout > 0L) {
            throw new UnsupportedOperationException();
        }
        this.write0(src, attachment, handler);
    }

    private <V extends Number, A> void write0(ByteBuffer writeBuffer, A attachment, CompletionHandler<V, ? super A> handler) {
        if (this.writeCompletionHandler != null) {
            throw new WritePendingException();
        }
        this.writeBuffer = writeBuffer;
        this.writeAttachment = attachment;
        this.writeCompletionHandler = handler;
        while (this.doWrite()) {
        }
    }

    @Override
    public final Future<Integer> write(ByteBuffer src) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final <A> void write(ByteBuffer[] srcs, int offset, int length, long timeout, TimeUnit unit, A attachment, CompletionHandler<Long, ? super A> handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final SocketAddress getLocalAddress() throws IOException {
        return this.channel.getLocalAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final void doRead(boolean direct) {
        try {
            if (this.readCompletionHandler == null) {
                return;
            }
            if (!this.channelGroup.running) {
                throw new IOException("channelGroup is shutdown");
            }
            if (this.readCompletionHandler instanceof FutureCompletionHandler && ((FutureCompletionHandler)this.readCompletionHandler).isDone()) {
                AsynchronousChannelGroup.removeOps(this.readSelectionKey, 1);
                this.resetRead();
                return;
            }
            if (this.lowMemory && direct && this.readBuffer == null) {
                completionHandler = this.readCompletionHandler;
                attach = this.readAttachment;
                this.resetRead();
                completionHandler.completed(-3, attach);
                return;
            }
            if (direct) ** GOTO lbl-1000
            v0 = this.readInvoker;
            this.readInvoker = (byte)(v0 + 1);
            if (v0 < 8) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            directRead = v1;
            readSize = 0;
            hasRemain = true;
            if (directRead) {
                readSize = this.channel.read(this.readBuffer);
                hasRemain = this.readBuffer.hasRemaining();
            }
            if (readSize == 0 && this.readCompletionHandler instanceof FutureCompletionHandler) {
                AsynchronousChannelGroup.removeOps(this.readSelectionKey, 1);
                this.channelGroup.commonWorker.addRegister((Consumer<Selector>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$doRead$0(java.nio.channels.Selector ), (Ljava/nio/channels/Selector;)V)((AsynchronousServerChannel)this));
                return;
            }
            if (this.lowMemory && readSize == 0 && this.readBuffer.position() == 0) {
                this.readBuffer = null;
                this.readCompletionHandler.completed(-2, this.readAttachment);
            }
            if (readSize != 0 || !hasRemain) {
                completionHandler = this.readCompletionHandler;
                attach = this.readAttachment;
                this.resetRead();
                completionHandler.completed(readSize, attach);
                if (this.readCompletionHandler == null && this.readSelectionKey != null) {
                    AsynchronousChannelGroup.removeOps(this.readSelectionKey, 1);
                }
            } else if (this.readSelectionKey == null) {
                this.readWorker.addRegister((Consumer<Selector>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$doRead$1(java.nio.channels.Selector ), (Ljava/nio/channels/Selector;)V)((AsynchronousServerChannel)this));
            } else {
                AsynchronousChannelGroup.interestOps(this.readWorker, this.readSelectionKey, 1);
            }
        }
        catch (Throwable e) {
            if (this.readCompletionHandler == null) {
                try {
                    this.close();
                }
                catch (Throwable readSize) {}
            } else {
                completionHandler = this.readCompletionHandler;
                attach = this.readAttachment;
                this.resetRead();
                completionHandler.failed(e, attach);
            }
        }
        finally {
            this.readInvoker = 0;
        }
    }

    private void resetRead() {
        this.readCompletionHandler = null;
        this.readAttachment = null;
        this.readBuffer = null;
    }

    public final boolean doWrite() {
        if (this.writeInterrupted) {
            this.writeInterrupted = false;
            return false;
        }
        try {
            if (!this.channelGroup.running) {
                throw new IOException("channelGroup is shutdown");
            }
            int writeSize = this.channel.write(this.writeBuffer);
            if (writeSize != 0 || !this.writeBuffer.hasRemaining()) {
                CompletionHandler<Number, Object> completionHandler = this.writeCompletionHandler;
                Object attach = this.writeAttachment;
                this.resetWrite();
                this.writeInterrupted = true;
                completionHandler.completed(writeSize, attach);
                if (!this.writeInterrupted) {
                    return true;
                }
                this.writeInterrupted = false;
            } else {
                SelectionKey commonSelectionKey = this.channel.keyFor(this.channelGroup.writeWorker.selector);
                if (commonSelectionKey == null) {
                    this.channelGroup.writeWorker.addRegister(selector -> {
                        try {
                            this.channel.register((Selector)selector, 4, this);
                        }
                        catch (ClosedChannelException e) {
                            this.writeCompletionHandler.failed(e, this.writeAttachment);
                        }
                    });
                } else {
                    AsynchronousChannelGroup.interestOps(this.channelGroup.writeWorker, commonSelectionKey, 4);
                }
            }
        }
        catch (Throwable e) {
            if (this.writeCompletionHandler == null) {
                e.printStackTrace();
                try {
                    this.close();
                }
                catch (IOException ioException) {
                    ioException.printStackTrace();
                }
            }
            this.writeCompletionHandler.failed(e, this.writeAttachment);
        }
        return false;
    }

    private void resetWrite() {
        this.writeAttachment = null;
        this.writeCompletionHandler = null;
        this.writeBuffer = null;
    }

    @Override
    public final boolean isOpen() {
        return this.channel.isOpen();
    }

    private /* synthetic */ void lambda$doRead$1(Selector selector) {
        try {
            this.readSelectionKey = this.channel.register(selector, 1, this);
        }
        catch (ClosedChannelException e) {
            this.readCompletionHandler.failed(e, this.readAttachment);
        }
    }

    private /* synthetic */ void lambda$doRead$0(Selector selector) {
        try {
            this.channel.register(selector, 1, this);
        }
        catch (ClosedChannelException e) {
            this.doRead(true);
        }
    }
}

