/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.socket.plugin;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.socket.plugin.AbstractPlugin;

public final class BlackListPlugin<T>
extends AbstractPlugin<T> {
    private ConcurrentLinkedQueue<BlackListRule> ipBlackList = new ConcurrentLinkedQueue();

    @Override
    public AsynchronousSocketChannel shouldAccept(AsynchronousSocketChannel channel) {
        InetSocketAddress inetSocketAddress = null;
        try {
            inetSocketAddress = (InetSocketAddress)channel.getRemoteAddress();
        }
        catch (IOException e) {
            Logger.error((String)"get remote address error.", (Object[])new Object[]{e});
        }
        if (inetSocketAddress == null) {
            return channel;
        }
        for (BlackListRule rule : this.ipBlackList) {
            if (rule.access(inetSocketAddress)) continue;
            return null;
        }
        return channel;
    }

    public void addRule(BlackListRule rule) {
        this.ipBlackList.add(rule);
    }

    public void removeRule(BlackListRule rule) {
        this.ipBlackList.remove(rule);
    }

    public static interface BlackListRule {
        public boolean access(InetSocketAddress var1);
    }
}

