/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.socket.plugin;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.socket.Session;
import org.miaixz.bus.socket.Status;
import org.miaixz.bus.socket.metric.HashedWheelTimer;
import org.miaixz.bus.socket.plugin.AbstractPlugin;

public abstract class HeartPlugin<T>
extends AbstractPlugin<T> {
    private static final TimeoutCallback DEFAULT_TIMEOUT_CALLBACK = (session, lastTime) -> session.close(true);
    private Map<Session, Long> sessionMap = new HashMap<Session, Long>();
    private long heartRate;
    private long timeout;
    private TimeoutCallback timeoutCallback;

    public HeartPlugin(int heartRate, TimeUnit timeUnit) {
        this(heartRate, 0, timeUnit);
    }

    public HeartPlugin(int heartRate, int timeout, TimeUnit unit) {
        this(heartRate, timeout, unit, DEFAULT_TIMEOUT_CALLBACK);
    }

    public HeartPlugin(int heartRate, int timeout, TimeUnit timeUnit, TimeoutCallback timeoutCallback) {
        if (timeout > 0 && heartRate >= timeout) {
            throw new IllegalArgumentException("heartRate must little then timeout");
        }
        this.heartRate = timeUnit.toMillis(heartRate);
        this.timeout = timeUnit.toMillis(timeout);
        this.timeoutCallback = timeoutCallback;
    }

    @Override
    public final boolean process(Session session, T data) {
        this.sessionMap.put(session, System.currentTimeMillis());
        return !this.isHeartMessage(session, data);
    }

    @Override
    public final void stateEvent(Status status, Session session, Throwable throwable) {
        switch (status) {
            case NEW_SESSION: {
                this.sessionMap.put(session, System.currentTimeMillis());
                this.registerHeart(session, this.heartRate);
                break;
            }
            case SESSION_CLOSED: {
                this.sessionMap.remove(session);
                break;
            }
        }
    }

    public abstract void sendHeartRequest(Session var1) throws IOException;

    public abstract boolean isHeartMessage(Session var1, T var2);

    private void registerHeart(final Session session, final long heartRate) {
        if (heartRate <= 0L) {
            Logger.info((String)"session:{} \u56e0\u5fc3\u8df3\u95f4\u9694\u4e3a:{},\u7ec8\u6b62\u542f\u52a8\u5fc3\u8df3\u76d1\u6d4b\u4efb\u52a1", (Object[])new Object[]{session, heartRate});
            return;
        }
        Logger.debug((String)"session:{}\u6ce8\u518c\u5fc3\u8df3\u4efb\u52a1,\u5fc3\u8df3\u95f4\u9694:{}", (Object[])new Object[]{session, heartRate});
        HashedWheelTimer.DEFAULT_TIMER.schedule(new TimerTask(this){
            final /* synthetic */ HeartPlugin this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (session.isInvalid()) {
                    this.this$0.sessionMap.remove(session);
                    Logger.info((String)"session:{} \u5df2\u5931\u6548\uff0c\u79fb\u9664\u5fc3\u8df3\u4efb\u52a1", (Object[])new Object[]{session});
                    return;
                }
                Long lastTime = this.this$0.sessionMap.get(session);
                if (lastTime == null) {
                    Logger.warn((String)"session:{} timeout is null", (Object[])new Object[]{session});
                    lastTime = System.currentTimeMillis();
                    this.this$0.sessionMap.put(session, lastTime);
                }
                long current = System.currentTimeMillis();
                if (this.this$0.timeout > 0L && current - lastTime > this.this$0.timeout) {
                    this.this$0.timeoutCallback.callback(session, lastTime);
                } else if (current - lastTime > heartRate) {
                    try {
                        this.this$0.sendHeartRequest(session);
                        session.writeBuffer().flush();
                    }
                    catch (IOException e) {
                        Logger.error((String)"heart exception,will close session:{}", (Object[])new Object[]{session, e});
                        session.close(true);
                    }
                }
                this.this$0.registerHeart(session, heartRate);
            }
        }, heartRate, TimeUnit.MILLISECONDS);
    }

    public static interface TimeoutCallback {
        public void callback(Session var1, long var2);
    }
}

