/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.socket.plugin;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.TimeUnit;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.socket.metric.HashedWheelTimer;
import org.miaixz.bus.socket.metric.SocketTask;
import org.miaixz.bus.socket.metric.channels.AsynchronousSocketChannelProxy;
import org.miaixz.bus.socket.plugin.AbstractPlugin;

public final class IdleStatePlugin<T>
extends AbstractPlugin<T> {
    private static final HashedWheelTimer timer = new HashedWheelTimer(r -> {
        Thread thread = new Thread(r, "idleStateMonitor");
        thread.setDaemon(true);
        return thread;
    });
    private final int idleTimeout;
    private final boolean writeMonitor;
    private final boolean readMonitor;

    public IdleStatePlugin(int idleTimeout) {
        this(idleTimeout, true, true);
    }

    public IdleStatePlugin(int idleTimeout, boolean readMonitor, boolean writeMonitor) {
        if (idleTimeout <= 0) {
            throw new IllegalArgumentException("invalid idleTimeout");
        }
        if (!writeMonitor && !readMonitor) {
            throw new IllegalArgumentException("readIdle and writeIdle both disable");
        }
        this.idleTimeout = idleTimeout;
        this.writeMonitor = writeMonitor;
        this.readMonitor = readMonitor;
    }

    @Override
    public AsynchronousSocketChannel shouldAccept(AsynchronousSocketChannel channel) {
        return new IdleMonitorChannel(channel);
    }

    class IdleMonitorChannel
    extends AsynchronousSocketChannelProxy {
        SocketTask task;
        long readTimestamp;
        long writeTimestamp;

        public IdleMonitorChannel(AsynchronousSocketChannel asynchronousSocketChannel) {
            super(asynchronousSocketChannel);
            if (!IdleStatePlugin.this.readMonitor) {
                this.readTimestamp = Long.MAX_VALUE;
            }
            if (!IdleStatePlugin.this.writeMonitor) {
                this.writeTimestamp = Long.MAX_VALUE;
            }
            this.task = timer.scheduleWithFixedDelay(() -> {
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.readTimestamp > (long)IdleStatePlugin.this.idleTimeout || currentTime - this.writeTimestamp > (long)IdleStatePlugin.this.idleTimeout) {
                    try {
                        if (asynchronousSocketChannel.isOpen() && Logger.isDebugEnabled()) {
                            Logger.debug((String)"close session:{} by IdleStatePlugin", (Object[])new Object[]{asynchronousSocketChannel.getRemoteAddress()});
                        }
                        this.close();
                    }
                    catch (IOException e) {
                        Logger.debug((String)"close exception", (Object[])new Object[]{e});
                    }
                }
            }, IdleStatePlugin.this.idleTimeout, TimeUnit.MILLISECONDS);
        }

        @Override
        public <A> void read(ByteBuffer dst, long timeout, TimeUnit unit, A attachment, CompletionHandler<Integer, ? super A> handler) {
            if (IdleStatePlugin.this.readMonitor) {
                this.readTimestamp = System.currentTimeMillis();
            }
            super.read(dst, timeout, unit, attachment, handler);
        }

        @Override
        public <A> void write(ByteBuffer src, long timeout, TimeUnit unit, A attachment, CompletionHandler<Integer, ? super A> handler) {
            if (IdleStatePlugin.this.writeMonitor) {
                this.writeTimestamp = System.currentTimeMillis();
            }
            super.write(src, timeout, unit, attachment, handler);
        }

        @Override
        public void close() throws IOException {
            this.task.cancel();
            super.close();
        }
    }
}

