/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.socket.plugin;

import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.HashMap;
import java.util.Map;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.socket.plugin.AbstractPlugin;

public class SocketOptionPlugin<T>
extends AbstractPlugin<T> {
    private Map<SocketOption<Object>, Object> optionMap = new HashMap<SocketOption<Object>, Object>();

    @Override
    public final AsynchronousSocketChannel shouldAccept(AsynchronousSocketChannel channel) {
        this.setOption(channel);
        return super.shouldAccept(channel);
    }

    public void setOption(AsynchronousSocketChannel channel) {
        try {
            if (!this.optionMap.containsKey(StandardSocketOptions.TCP_NODELAY)) {
                channel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
            }
            for (Map.Entry<SocketOption<Object>, Object> entry : this.optionMap.entrySet()) {
                channel.setOption((SocketOption)entry.getKey(), entry.getValue());
            }
        }
        catch (IOException e) {
            Logger.error((String)"", (Object[])new Object[]{e});
        }
    }

    public final <V> SocketOptionPlugin<T> setOption(SocketOption<V> socketOption, V value) {
        this.put0(socketOption, value);
        return this;
    }

    public final <V> V getOption(SocketOption<V> socketOption) {
        Object value = this.optionMap.get(socketOption);
        return (V)(value == null ? null : value);
    }

    private void put0(SocketOption socketOption, Object value) {
        this.optionMap.put(socketOption, value);
    }
}

