/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.socket.secure.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.socket.buffer.BufferPage;
import org.miaixz.bus.socket.secure.ssl.HandshakeModel;

public final class SslService {
    private final SSLContext sslContext;
    private final Consumer<SSLEngine> consumer;
    private boolean debug;
    private final CompletionHandler<Integer, HandshakeModel> handshakeCompletionHandler = new CompletionHandler<Integer, HandshakeModel>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void completed(Integer result, HandshakeModel attachment) {
            if (result == -1) {
                this.failed((Throwable)new IOException("eof"), attachment);
                return;
            }
            if (result != -2) {
                HandshakeModel handshakeModel = attachment;
                synchronized (handshakeModel) {
                    SslService.this.doHandshake(attachment);
                }
            }
        }

        @Override
        public void failed(Throwable exc, HandshakeModel attachment) {
            attachment.setException(exc);
            attachment.getHandshakeCallback().callback();
        }
    };

    public SslService(SSLContext sslContext, Consumer<SSLEngine> consumer) {
        this.sslContext = sslContext;
        this.consumer = consumer;
    }

    HandshakeModel createSSLEngine(AsynchronousSocketChannel socketChannel, BufferPage bufferPage) {
        try {
            HandshakeModel handshakeModel = new HandshakeModel();
            SSLEngine sslEngine = this.sslContext.createSSLEngine();
            SSLSession session = sslEngine.getSession();
            this.consumer.accept(sslEngine);
            handshakeModel.setSslEngine(sslEngine);
            handshakeModel.setAppWriteBuffer(bufferPage.allocate(session.getApplicationBufferSize()));
            handshakeModel.setNetWriteBuffer(bufferPage.allocate(session.getPacketBufferSize()));
            handshakeModel.getNetWriteBuffer().buffer().flip();
            handshakeModel.setAppReadBuffer(bufferPage.allocate(session.getApplicationBufferSize()));
            handshakeModel.setNetReadBuffer(bufferPage.allocate(session.getPacketBufferSize()));
            sslEngine.beginHandshake();
            handshakeModel.setSocketChannel(socketChannel);
            return handshakeModel;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void doHandshake(HandshakeModel handshakeModel) {
        try {
            ByteBuffer netReadBuffer = handshakeModel.getNetReadBuffer().buffer();
            ByteBuffer appReadBuffer = handshakeModel.getAppReadBuffer().buffer();
            ByteBuffer netWriteBuffer = handshakeModel.getNetWriteBuffer().buffer();
            ByteBuffer appWriteBuffer = handshakeModel.getAppWriteBuffer().buffer();
            SSLEngine engine = handshakeModel.getSslEngine();
            if (handshakeModel.getException() != null) {
                if (this.debug) {
                    Logger.info((String)"the ssl handshake is terminated", (Object[])new Object[0]);
                }
                handshakeModel.getHandshakeCallback().callback();
                return;
            }
            block22: while (!handshakeModel.isFinished()) {
                SSLEngineResult.HandshakeStatus handshakeStatus = engine.getHandshakeStatus();
                if (this.debug) {
                    Logger.info((String)("\u63e1\u624b\u72b6\u6001:" + String.valueOf((Object)handshakeStatus)), (Object[])new Object[0]);
                }
                switch (handshakeStatus) {
                    case NEED_UNWRAP: {
                        netReadBuffer.flip();
                        if (!netReadBuffer.hasRemaining()) {
                            netReadBuffer.clear();
                            handshakeModel.getSocketChannel().read(netReadBuffer, handshakeModel, this.handshakeCompletionHandler);
                            return;
                        }
                        SSLEngineResult result = engine.unwrap(netReadBuffer, appReadBuffer);
                        netReadBuffer.compact();
                        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                            handshakeModel.setFinished(true);
                        }
                        switch (result.getStatus()) {
                            case OK: {
                                continue block22;
                            }
                            case BUFFER_OVERFLOW: {
                                Logger.warn((String)"doHandshake BUFFER_OVERFLOW", (Object[])new Object[0]);
                                continue block22;
                            }
                            case BUFFER_UNDERFLOW: {
                                if (netReadBuffer.position() > 0) {
                                    handshakeModel.getSocketChannel().read(netReadBuffer, handshakeModel, this.handshakeCompletionHandler);
                                } else {
                                    Logger.warn((String)"doHandshake BUFFER_UNDERFLOW", (Object[])new Object[0]);
                                }
                                return;
                            }
                        }
                        throw new IllegalStateException("Invalid SSL status: " + String.valueOf((Object)result.getStatus()));
                    }
                    case NEED_WRAP: {
                        if (netWriteBuffer.hasRemaining()) {
                            if (this.debug) {
                                Logger.info((String)"\u6570\u636e\u672a\u8f93\u51fa\u5b8c\u6bd5...", (Object[])new Object[0]);
                            }
                            handshakeModel.getSocketChannel().write(netWriteBuffer, handshakeModel, this.handshakeCompletionHandler);
                            return;
                        }
                        netWriteBuffer.clear();
                        SSLEngineResult result = engine.wrap(appWriteBuffer, netWriteBuffer);
                        switch (result.getStatus()) {
                            case OK: {
                                appWriteBuffer.clear();
                                netWriteBuffer.flip();
                                if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                                    handshakeModel.setFinished(true);
                                }
                                handshakeModel.getSocketChannel().write(netWriteBuffer, handshakeModel, this.handshakeCompletionHandler);
                                return;
                            }
                            case BUFFER_OVERFLOW: {
                                if (!this.debug) continue block22;
                                Logger.warn((String)"NEED_WRAP BUFFER_OVERFLOW", (Object[])new Object[0]);
                                continue block22;
                            }
                            case BUFFER_UNDERFLOW: {
                                throw new SSLException("Buffer underflow occurred after a wrap. I don't think we should ever get here.");
                            }
                            case CLOSED: {
                                if (this.debug) {
                                    Logger.warn((String)"closed", (Object[])new Object[0]);
                                }
                                try {
                                    netWriteBuffer.flip();
                                    netReadBuffer.clear();
                                }
                                catch (Exception e) {
                                    if (!this.debug) continue block22;
                                    Logger.error((String)"Failed to send server's CLOSE message due to socket channel's failure.", (Object[])new Object[0]);
                                }
                                continue block22;
                            }
                        }
                        throw new IllegalStateException("Invalid SSL status: " + String.valueOf((Object)result.getStatus()));
                    }
                    case NEED_TASK: {
                        Runnable task;
                        while ((task = engine.getDelegatedTask()) != null) {
                            task.run();
                        }
                        continue block22;
                    }
                    case FINISHED: {
                        if (!this.debug) continue block22;
                        Logger.info((String)"HandshakeFinished", (Object[])new Object[0]);
                        continue block22;
                    }
                    case NOT_HANDSHAKING: {
                        if (!this.debug) continue block22;
                        Logger.error((String)"NOT_HANDSHAKING", (Object[])new Object[0]);
                        continue block22;
                    }
                }
                throw new IllegalStateException("Invalid SSL status: " + String.valueOf((Object)handshakeStatus));
            }
            handshakeModel.getHandshakeCallback().callback();
        }
        catch (Exception e) {
            if (this.debug) {
                Logger.error((String)("ignore doHandshake exception:" + e.getMessage()), (Object[])new Object[0]);
            }
            this.handshakeCompletionHandler.failed(e, handshakeModel);
        }
    }

    public void debug(boolean debug) {
        this.debug = debug;
    }

    boolean isDebug() {
        return this.debug;
    }
}

