/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.socket.plugin;

import java.nio.channels.AsynchronousSocketChannel;
import java.util.function.Consumer;
import javax.net.ssl.SSLEngine;
import org.miaixz.bus.socket.buffer.BufferPagePool;
import org.miaixz.bus.socket.plugin.AbstractPlugin;
import org.miaixz.bus.socket.secure.ssl.ClientAuth;
import org.miaixz.bus.socket.secure.ssl.SslAsynchronousSocketChannel;
import org.miaixz.bus.socket.secure.ssl.SslService;
import org.miaixz.bus.socket.secure.ssl.factory.ClientSSLContextFactory;
import org.miaixz.bus.socket.secure.ssl.factory.SSLContextFactory;
import org.miaixz.bus.socket.secure.ssl.factory.ServerSSLContextFactory;

public final class SslPlugin<T>
extends AbstractPlugin<T> {
    private final SslService sslService;
    private final BufferPagePool bufferPagePool;

    public SslPlugin(SSLContextFactory factory, Consumer<SSLEngine> consumer) throws Exception {
        this(factory, consumer, BufferPagePool.DEFAULT_BUFFER_PAGE_POOL);
    }

    public SslPlugin(SSLContextFactory factory) throws Exception {
        this(factory, (SSLEngine sslEngine) -> sslEngine.setUseClientMode(false), BufferPagePool.DEFAULT_BUFFER_PAGE_POOL);
    }

    public SslPlugin(SSLContextFactory factory, Consumer<SSLEngine> consumer, BufferPagePool bufferPagePool) throws Exception {
        this.bufferPagePool = bufferPagePool;
        this.sslService = new SslService(factory.create(), consumer);
    }

    public SslPlugin(ClientSSLContextFactory factory) throws Exception {
        this(factory, BufferPagePool.DEFAULT_BUFFER_PAGE_POOL);
    }

    public SslPlugin(ClientSSLContextFactory factory, BufferPagePool bufferPagePool) throws Exception {
        this(factory, (SSLEngine sslEngine) -> sslEngine.setUseClientMode(true), bufferPagePool);
    }

    public SslPlugin(ServerSSLContextFactory factory, ClientAuth clientAuth) throws Exception {
        this(factory, clientAuth, BufferPagePool.DEFAULT_BUFFER_PAGE_POOL);
    }

    public SslPlugin(ServerSSLContextFactory factory, ClientAuth clientAuth, BufferPagePool bufferPagePool) throws Exception {
        this((SSLContextFactory)factory, (SSLEngine sslEngine) -> {
            sslEngine.setUseClientMode(false);
            switch (clientAuth) {
                case OPTIONAL: {
                    sslEngine.setWantClientAuth(true);
                    break;
                }
                case REQUIRE: {
                    sslEngine.setNeedClientAuth(true);
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new Error("Unknown auth " + String.valueOf((Object)clientAuth));
                }
            }
        }, bufferPagePool);
    }

    @Override
    public AsynchronousSocketChannel shouldAccept(AsynchronousSocketChannel channel) {
        return new SslAsynchronousSocketChannel(channel, this.sslService, this.bufferPagePool.allocateBufferPage());
    }

    public void debug(boolean debug) {
        this.sslService.debug(debug);
    }
}

