/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.socket.accord;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.socket.Context;
import org.miaixz.bus.socket.Handler;
import org.miaixz.bus.socket.Monitor;
import org.miaixz.bus.socket.Session;
import org.miaixz.bus.socket.Status;
import org.miaixz.bus.socket.buffer.BufferPage;
import org.miaixz.bus.socket.buffer.VirtualBuffer;
import org.miaixz.bus.socket.buffer.WriteBuffer;

public class TcpSession
extends Session {
    private final AsynchronousSocketChannel channel;
    private final WriteBuffer byteBuf;
    private final Context context;
    private final Supplier<VirtualBuffer> readBufferSupplier;
    private VirtualBuffer readBuffer;
    private VirtualBuffer writeBuffer;
    private InputStream inputStream;
    private static final CompletionHandler<Integer, TcpSession> READ_COMPLETION_HANDLER = new CompletionHandler<Integer, TcpSession>(){

        @Override
        public void completed(Integer result, TcpSession session) {
            try {
                session.readCompleted(result);
            }
            catch (Throwable throwable) {
                this.failed(throwable, session);
            }
        }

        @Override
        public void failed(Throwable exc, TcpSession session) {
            try {
                session.context.getProcessor().stateEvent(session, Status.INPUT_EXCEPTION, exc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                session.close(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private static final CompletionHandler<Integer, TcpSession> WRITE_COMPLETION_HANDLER = new CompletionHandler<Integer, TcpSession>(){

        @Override
        public void completed(Integer result, TcpSession session) {
            try {
                session.writeCompleted(result);
            }
            catch (Throwable throwable) {
                this.failed(throwable, session);
            }
        }

        @Override
        public void failed(Throwable exc, TcpSession session) {
            try {
                session.context.getProcessor().stateEvent(session, Status.OUTPUT_EXCEPTION, exc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                session.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    public TcpSession(AsynchronousSocketChannel channel, Context context, BufferPage writeBufferPage, Supplier<VirtualBuffer> readBufferSupplier) {
        this.channel = channel;
        this.context = context;
        this.readBufferSupplier = readBufferSupplier;
        this.byteBuf = new WriteBuffer(writeBufferPage, this::continueWrite, this.context.getWriteBufferSize(), this.context.getWriteBufferCapacity());
        this.context.getProcessor().stateEvent(this, Status.NEW_SESSION, null);
        this.doRead();
    }

    void doRead() {
        this.readBuffer = this.readBufferSupplier.get();
        this.readBuffer.buffer().flip();
        this.signalRead();
    }

    void writeCompleted(int result) {
        Monitor monitor = this.context.getMonitor();
        if (monitor != null) {
            monitor.afterWrite(this, result);
        }
        VirtualBuffer writeBuffer = this.writeBuffer;
        this.writeBuffer = null;
        if (writeBuffer == null) {
            writeBuffer = this.byteBuf.poll();
        } else if (!writeBuffer.buffer().hasRemaining()) {
            writeBuffer.clean();
            writeBuffer = this.byteBuf.poll();
        }
        if (writeBuffer != null) {
            this.continueWrite(writeBuffer);
            return;
        }
        this.byteBuf.finishWrite();
        if (this.status != 3) {
            this.close();
        } else {
            this.byteBuf.flush();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void close(boolean immediate) {
        if (this.status == 1) {
            return;
        }
        this.status = (byte)(immediate ? 1 : 2);
        if (immediate) {
            try {
                this.byteBuf.close();
                if (this.readBuffer != null) {
                    this.readBuffer.clean();
                    this.readBuffer = null;
                }
                if (this.writeBuffer == null) return;
                this.writeBuffer.clean();
                this.writeBuffer = null;
                return;
            }
            finally {
                IoKit.close((AsynchronousSocketChannel)this.channel);
                this.context.getProcessor().stateEvent(this, Status.SESSION_CLOSED, null);
            }
        } else if ((this.writeBuffer == null || !this.writeBuffer.buffer().hasRemaining()) && this.byteBuf.isEmpty()) {
            this.close(true);
            return;
        } else {
            this.context.getProcessor().stateEvent(this, Status.SESSION_CLOSING, null);
            this.byteBuf.flush();
        }
    }

    @Override
    public WriteBuffer writeBuffer() {
        return this.byteBuf;
    }

    @Override
    public ByteBuffer readBuffer() {
        return this.readBuffer.buffer();
    }

    @Override
    public void awaitRead() {
        ++this.modCount;
    }

    void readCompleted(int result) {
        if (result == -2) {
            this.readBuffer.clean();
            this.readBuffer = null;
            return;
        }
        if (result == -3) {
            this.doRead();
            return;
        }
        Monitor monitor = this.context.getMonitor();
        if (monitor != null) {
            monitor.afterRead(this, result);
        }
        boolean bl = this.eof = result == -1;
        if (1 != this.status) {
            this.readBuffer.buffer().flip();
            this.signalRead();
        }
    }

    @Override
    public void signalRead() {
        int modCount = this.modCount;
        if (this.status == 1) {
            return;
        }
        ByteBuffer readBuffer = this.readBuffer.buffer();
        Handler handler = this.context.getProcessor();
        while (readBuffer.hasRemaining() && this.status == 3) {
            Object dataEntry;
            try {
                dataEntry = this.context.getProtocol().decode(readBuffer, this);
            }
            catch (Exception e) {
                handler.stateEvent(this, Status.DECODE_EXCEPTION, e);
                throw e;
            }
            if (dataEntry == null) break;
            try {
                handler.process(this, dataEntry);
                if (modCount == this.modCount) continue;
                return;
            }
            catch (Exception e) {
                handler.stateEvent(this, Status.PROCESS_EXCEPTION, e);
            }
        }
        if (this.eof || this.status == 2) {
            this.close(false);
            handler.stateEvent(this, Status.INPUT_SHUTDOWN, null);
            return;
        }
        if (this.status == 1) {
            return;
        }
        this.byteBuf.flush();
        readBuffer.compact();
        if (!readBuffer.hasRemaining()) {
            InternalException exception = new InternalException("readBuffer overflow. The current TCP connection will be closed. Please fix your " + this.context.getProtocol().getClass().getSimpleName() + "#decode bug.");
            handler.stateEvent(this, Status.DECODE_EXCEPTION, (Throwable)exception);
            throw exception;
        }
        Monitor monitor = this.context.getMonitor();
        if (monitor != null) {
            monitor.beforeRead(this);
        }
        this.channel.read(readBuffer, 0L, TimeUnit.MILLISECONDS, this, READ_COMPLETION_HANDLER);
    }

    private void continueWrite(VirtualBuffer writeBuffer) {
        this.writeBuffer = writeBuffer;
        Monitor monitor = this.context.getMonitor();
        if (monitor != null) {
            monitor.beforeWrite(this);
        }
        this.channel.write(writeBuffer.buffer(), 0L, TimeUnit.MILLISECONDS, this, WRITE_COMPLETION_HANDLER);
    }

    @Override
    public InetSocketAddress getLocalAddress() throws IOException {
        this.assertChannel();
        return (InetSocketAddress)this.channel.getLocalAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() throws IOException {
        this.assertChannel();
        return (InetSocketAddress)this.channel.getRemoteAddress();
    }

    private int synRead() throws IOException {
        ByteBuffer buffer = this.readBuffer.buffer();
        if (buffer.remaining() > 0) {
            return 0;
        }
        try {
            buffer.clear();
            int size = this.channel.read(buffer).get();
            buffer.flip();
            return size;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void assertChannel() throws IOException {
        if (this.status == 1 || this.channel == null) {
            throw new IOException("session is closed");
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.inputStream == null ? this.getInputStream(-1) : this.inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream(int length) throws IOException {
        if (this.inputStream != null) {
            throw new IOException("pre inputStream has not closed");
        }
        TcpSession tcpSession = this;
        synchronized (tcpSession) {
            if (this.inputStream == null) {
                this.inputStream = new InnerInputStream(length);
            }
        }
        return this.inputStream;
    }

    private class InnerInputStream
    extends InputStream {
        private int remainLength;

        InnerInputStream(int length) {
            this.remainLength = length >= 0 ? length : -1;
        }

        @Override
        public int read() throws IOException {
            if (this.remainLength == 0) {
                return -1;
            }
            ByteBuffer readBuffer = TcpSession.this.readBuffer.buffer();
            if (readBuffer.hasRemaining()) {
                --this.remainLength;
                return readBuffer.get();
            }
            if (TcpSession.this.synRead() == -1) {
                this.remainLength = 0;
            }
            return this.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (this.remainLength == 0) {
                return -1;
            }
            if (this.remainLength > 0 && this.remainLength < len) {
                len = this.remainLength;
            }
            ByteBuffer readBuffer = TcpSession.this.readBuffer.buffer();
            int size = 0;
            while (len > 0 && TcpSession.this.synRead() != -1) {
                int readSize = Math.min(readBuffer.remaining(), len);
                readBuffer.get(b, off + size, readSize);
                size += readSize;
                len -= readSize;
            }
            this.remainLength -= size;
            return size;
        }

        @Override
        public int available() throws IOException {
            if (this.remainLength == 0) {
                return 0;
            }
            if (TcpSession.this.synRead() == -1) {
                this.remainLength = 0;
                return this.remainLength;
            }
            ByteBuffer readBuffer = TcpSession.this.readBuffer.buffer();
            if (this.remainLength < -1) {
                return readBuffer.remaining();
            }
            return Math.min(this.remainLength, readBuffer.remaining());
        }

        @Override
        public void close() {
            if (TcpSession.this.inputStream == this) {
                TcpSession.this.inputStream = null;
            }
        }
    }
}

