/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.socket.metric.message;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.miaixz.bus.socket.Message;
import org.miaixz.bus.socket.Session;
import org.miaixz.bus.socket.metric.decoder.FixedLengthFrameDecoder;

public class StringMessage
implements Message<String> {
    private final Charset charset;
    private final Map<Session, FixedLengthFrameDecoder> decoderMap = new ConcurrentHashMap<Session, FixedLengthFrameDecoder>();
    private long lastClearTime = System.currentTimeMillis();

    public StringMessage(Charset charset) {
        this.charset = charset;
    }

    public StringMessage() {
        this(org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    @Override
    public String decode(ByteBuffer readBuffer, Session session) {
        FixedLengthFrameDecoder decoder;
        if (System.currentTimeMillis() - this.lastClearTime > 5000L) {
            this.lastClearTime = System.currentTimeMillis();
            this.decoderMap.keySet().stream().filter(Session::isInvalid).forEach(this.decoderMap::remove);
        }
        if ((decoder = this.decoderMap.get(session)) != null) {
            String content = this.bigContent(readBuffer, decoder);
            if (content != null) {
                this.decoderMap.remove(session);
            }
            return content;
        }
        int remaining = readBuffer.remaining();
        if (remaining < 4) {
            return null;
        }
        readBuffer.mark();
        int length = readBuffer.getInt();
        if (length + 4 > readBuffer.capacity()) {
            FixedLengthFrameDecoder fixedLengthFrameDecoder = new FixedLengthFrameDecoder(length);
            this.decoderMap.put(session, fixedLengthFrameDecoder);
            return null;
        }
        if (length > readBuffer.remaining()) {
            readBuffer.reset();
            return null;
        }
        return this.convert(readBuffer, length);
    }

    private String bigContent(ByteBuffer readBuffer, FixedLengthFrameDecoder decoder) {
        if (!decoder.decode(readBuffer)) {
            return null;
        }
        ByteBuffer byteBuffer = decoder.getBuffer();
        return this.convert(byteBuffer, byteBuffer.capacity());
    }

    private String convert(ByteBuffer byteBuffer, int length) {
        byte[] b = new byte[length];
        byteBuffer.get(b);
        return new String(b, this.charset);
    }
}

