/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.socket.plugin;

import java.lang.reflect.Field;
import java.util.concurrent.TimeUnit;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.socket.accord.AioServer;
import org.miaixz.bus.socket.buffer.BufferPage;
import org.miaixz.bus.socket.buffer.BufferPagePool;
import org.miaixz.bus.socket.metric.HashedWheelTimer;
import org.miaixz.bus.socket.metric.SocketTask;
import org.miaixz.bus.socket.plugin.AbstractPlugin;

public class BufferPageMonitorPlugin<T>
extends AbstractPlugin<T> {
    private int seconds;
    private AioServer server;
    private SocketTask future;

    public BufferPageMonitorPlugin(AioServer server, int seconds) {
        this.seconds = seconds;
        this.server = server;
        this.init();
    }

    private static void dumpBufferPool(BufferPagePool writeBufferPool) throws NoSuchFieldException, IllegalAccessException {
        Field field = BufferPagePool.class.getDeclaredField("bufferPages");
        field.setAccessible(true);
        BufferPage[] pages = (BufferPage[])field.get(writeBufferPool);
        Object logger = "";
        for (BufferPage page : pages) {
            logger = (String)logger + "\r\n" + page.toString();
        }
        Logger.info((String)logger, (Object[])new Object[0]);
    }

    private void init() {
        this.future = HashedWheelTimer.DEFAULT_TIMER.scheduleWithFixedDelay(() -> {
            if (this.server == null) {
                Logger.error((String)"unKnow server or client need to monitor!", (Object[])new Object[0]);
                this.shutdown();
                return;
            }
            try {
                Field bufferPoolField = AioServer.class.getDeclaredField("writeBufferPool");
                bufferPoolField.setAccessible(true);
                BufferPagePool writeBufferPool = (BufferPagePool)bufferPoolField.get(this.server);
                if (writeBufferPool == null) {
                    Logger.error((String)"server maybe has not started!", (Object[])new Object[0]);
                    this.shutdown();
                    return;
                }
                Field readBufferPoolField = AioServer.class.getDeclaredField("readBufferPool");
                readBufferPoolField.setAccessible(true);
                BufferPagePool readBufferPool = (BufferPagePool)readBufferPoolField.get(this.server);
                if (readBufferPool != null && readBufferPool != writeBufferPool) {
                    Logger.info((String)"dump writeBuffer", (Object[])new Object[0]);
                    BufferPageMonitorPlugin.dumpBufferPool(writeBufferPool);
                    Logger.info((String)"dump readBuffer", (Object[])new Object[0]);
                    BufferPageMonitorPlugin.dumpBufferPool(readBufferPool);
                } else {
                    BufferPageMonitorPlugin.dumpBufferPool(writeBufferPool);
                }
            }
            catch (Exception e) {
                Logger.error((String)"", (Object[])new Object[]{e});
            }
        }, this.seconds, TimeUnit.SECONDS);
    }

    private void shutdown() {
        if (this.future != null) {
            this.future.cancel();
            this.future = null;
        }
    }
}

