/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.socket.buffer;

import java.nio.ByteBuffer;
import java.util.concurrent.Semaphore;
import org.miaixz.bus.socket.buffer.BufferPage;

public final class VirtualBuffer {
    private final BufferPage bufferPage;
    private final Semaphore clean = new Semaphore(1);
    private ByteBuffer buffer;
    private int parentPosition;
    private int parentLimit;
    private int capacity;

    VirtualBuffer(BufferPage bufferPage, ByteBuffer buffer, int parentPosition, int parentLimit) {
        this.bufferPage = bufferPage;
        this.buffer = buffer;
        this.parentPosition = parentPosition;
        this.parentLimit = parentLimit;
        this.updateCapacity();
    }

    public static VirtualBuffer wrap(ByteBuffer buffer) {
        return new VirtualBuffer(null, buffer, 0, 0);
    }

    int getParentPosition() {
        return this.parentPosition;
    }

    void setParentPosition(int parentPosition) {
        this.parentPosition = parentPosition;
        this.updateCapacity();
    }

    int getParentLimit() {
        return this.parentLimit;
    }

    void setParentLimit(int parentLimit) {
        this.parentLimit = parentLimit;
        this.updateCapacity();
    }

    private void updateCapacity() {
        this.capacity = this.parentLimit - this.parentPosition;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    void buffer(ByteBuffer buffer) {
        this.buffer = buffer;
        this.clean.release();
    }

    public void clean() {
        if (this.clean.tryAcquire()) {
            if (this.bufferPage != null) {
                this.bufferPage.clean(this);
            }
        } else {
            throw new UnsupportedOperationException("buffer has cleaned");
        }
    }

    public String toString() {
        return "VirtualBuffer{parentPosition=" + this.parentPosition + ", parentLimit=" + this.parentLimit + "}";
    }
}

