/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.socket.accord;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import org.miaixz.bus.socket.Context;
import org.miaixz.bus.socket.Handler;
import org.miaixz.bus.socket.Message;
import org.miaixz.bus.socket.Worker;
import org.miaixz.bus.socket.accord.UdpChannel;
import org.miaixz.bus.socket.buffer.BufferPagePool;

public class UdpBootstrap {
    private final Context context = new Context();
    private Worker worker;
    private boolean innerWorker = false;
    private BufferPagePool writeBufferPool = null;
    private BufferPagePool readBufferPool = null;

    public <Request> UdpBootstrap(Message<Request> message, Handler<Request> handler, Worker worker) {
        this(message, handler);
        this.worker = worker;
    }

    public <Request> UdpBootstrap(Message<Request> message, Handler<Request> handler) {
        this.context.setProtocol(message);
        this.context.setProcessor(handler);
    }

    public UdpChannel open() throws IOException {
        return this.open(0);
    }

    public UdpChannel open(int port) throws IOException {
        return this.open(null, port);
    }

    public UdpChannel open(String host, int port) throws IOException {
        if (this.writeBufferPool == null) {
            this.writeBufferPool = BufferPagePool.DEFAULT_BUFFER_PAGE_POOL;
        }
        if (this.readBufferPool == null) {
            this.readBufferPool = BufferPagePool.DEFAULT_BUFFER_PAGE_POOL;
        }
        if (this.worker == null) {
            this.innerWorker = true;
            this.worker = new Worker(this.readBufferPool.allocateBufferPage(), this.writeBufferPool, this.context.getThreadNum());
        }
        DatagramChannel channel = DatagramChannel.open();
        channel.configureBlocking(false);
        if (port > 0) {
            InetSocketAddress inetSocketAddress = host == null ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
            channel.socket().bind(inetSocketAddress);
        }
        return new UdpChannel(channel, this.worker, this.context, this.writeBufferPool.allocateBufferPage());
    }

    private synchronized void initWorker() {
        if (this.worker != null) {
            return;
        }
    }

    public void shutdown() {
        if (this.innerWorker) {
            this.worker.shutdown();
        }
    }

    public final UdpBootstrap setReadBufferSize(int size) {
        this.context.setReadBufferSize(size);
        return this;
    }

    public final UdpBootstrap setThreadNum(int num) {
        this.context.setThreadNum(num);
        return this;
    }

    public final UdpBootstrap setBufferPagePool(BufferPagePool bufferPool) {
        this.readBufferPool = bufferPool;
        this.writeBufferPool = bufferPool;
        return this;
    }
}

