/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.socket.accord;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.socket.Context;
import org.miaixz.bus.socket.Session;
import org.miaixz.bus.socket.Worker;
import org.miaixz.bus.socket.accord.UdpSession;
import org.miaixz.bus.socket.buffer.BufferPage;
import org.miaixz.bus.socket.buffer.VirtualBuffer;

public class UdpChannel {
    public final Context context;
    private final BufferPage writeBufferPage;
    private final DatagramChannel channel;
    private ConcurrentLinkedQueue<ResponseUnit> responseTasks;
    private Worker worker;
    private SelectionKey selectionKey;
    private ResponseUnit failResponseUnit;

    UdpChannel(DatagramChannel channel, Context context, BufferPage writeBufferPage) {
        this.channel = channel;
        this.writeBufferPage = writeBufferPage;
        this.context = context;
    }

    UdpChannel(DatagramChannel channel, Worker worker, Context context, BufferPage writeBufferPage) {
        this(channel, context, writeBufferPage);
        this.responseTasks = new ConcurrentLinkedQueue();
        this.worker = worker;
        worker.addRegister(selector -> {
            try {
                this.selectionKey = channel.register((Selector)selector, 1, this);
            }
            catch (ClosedChannelException e) {
                e.printStackTrace();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(VirtualBuffer virtualBuffer, UdpSession session) {
        if (this.send(virtualBuffer, session)) {
            return;
        }
        this.responseTasks.offer(new ResponseUnit(session, virtualBuffer));
        UdpChannel udpChannel = this;
        synchronized (udpChannel) {
            if (this.selectionKey == null) {
                this.worker.addRegister(selector -> this.selectionKey.interestOps(this.selectionKey.interestOps() | 4));
            } else if ((this.selectionKey.interestOps() & 4) == 0) {
                this.selectionKey.interestOps(this.selectionKey.interestOps() | 4);
            }
        }
    }

    public void doWrite() {
        ResponseUnit responseUnit;
        do {
            if (this.failResponseUnit == null) {
                responseUnit = this.responseTasks.poll();
            } else {
                responseUnit = this.failResponseUnit;
                this.failResponseUnit = null;
            }
            if (responseUnit != null) continue;
            if (this.responseTasks.isEmpty()) {
                this.selectionKey.interestOps(this.selectionKey.interestOps() & 0xFFFFFFFB);
                if (!this.responseTasks.isEmpty()) {
                    this.selectionKey.interestOps(this.selectionKey.interestOps() | 4);
                }
            }
            return;
        } while (this.send(responseUnit.response, responseUnit.session));
        this.failResponseUnit = responseUnit;
        Logger.warn((String)"send fail,will retry...", (Object[])new Object[0]);
    }

    private boolean send(VirtualBuffer virtualBuffer, UdpSession session) {
        int size;
        if (this.context.getMonitor() != null) {
            this.context.getMonitor().beforeWrite(session);
        }
        try {
            size = this.channel.send(virtualBuffer.buffer(), session.getRemoteAddress());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (size == 0) {
            return false;
        }
        if (this.context.getMonitor() != null) {
            this.context.getMonitor().afterWrite(session, size);
        }
        virtualBuffer.clean();
        session.writeBuffer().finishWrite();
        session.writeBuffer().flush();
        return true;
    }

    public Session connect(SocketAddress remote) {
        return new UdpSession(this, remote, this.writeBufferPage);
    }

    public Session connect(String host, int port) {
        return this.connect(new InetSocketAddress(host, port));
    }

    public void close() {
        ResponseUnit task;
        Logger.info((String)"close channel...", (Object[])new Object[0]);
        if (this.selectionKey != null) {
            Selector selector = this.selectionKey.selector();
            this.selectionKey.cancel();
            selector.wakeup();
            this.selectionKey = null;
        }
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (IOException e) {
            Logger.error((String)"", (Object[])new Object[]{e});
        }
        while ((task = this.responseTasks.poll()) != null) {
            task.response.clean();
        }
        if (this.failResponseUnit != null) {
            this.failResponseUnit.response.clean();
        }
    }

    public DatagramChannel getChannel() {
        return this.channel;
    }

    static final class ResponseUnit {
        private final UdpSession session;
        private final VirtualBuffer response;

        public ResponseUnit(UdpSession session, VirtualBuffer response) {
            this.session = session;
            this.response = response;
        }
    }
}

