/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.socket.metric.channels;

import java.io.IOException;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.miaixz.bus.socket.metric.channels.AsynchronousChannelGroup;
import org.miaixz.bus.socket.metric.channels.AsynchronousClientChannel;
import org.miaixz.bus.socket.metric.channels.AsynchronousServerSocketChannel;

public final class AsynchronousChannelProvider
extends java.nio.channels.spi.AsynchronousChannelProvider {
    public static final int READ_MONITOR_SIGNAL = -2;
    public static final int READABLE_SIGNAL = -3;
    private final boolean lowMemory;

    public AsynchronousChannelProvider(boolean lowMemory) {
        this.lowMemory = lowMemory;
    }

    @Override
    public java.nio.channels.AsynchronousChannelGroup openAsynchronousChannelGroup(int nThreads, ThreadFactory threadFactory) throws IOException {
        return new AsynchronousChannelGroup(this, new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(nThreads), threadFactory), nThreads);
    }

    @Override
    public java.nio.channels.AsynchronousChannelGroup openAsynchronousChannelGroup(ExecutorService executor, int initialSize) throws IOException {
        return new AsynchronousChannelGroup(this, executor, initialSize);
    }

    @Override
    public java.nio.channels.AsynchronousServerSocketChannel openAsynchronousServerSocketChannel(java.nio.channels.AsynchronousChannelGroup group) throws IOException {
        return new AsynchronousServerSocketChannel(this.checkAndGet(group), this.lowMemory);
    }

    @Override
    public AsynchronousSocketChannel openAsynchronousSocketChannel(java.nio.channels.AsynchronousChannelGroup group) throws IOException {
        return new AsynchronousClientChannel(this.checkAndGet(group), SocketChannel.open(), this.lowMemory);
    }

    private AsynchronousChannelGroup checkAndGet(java.nio.channels.AsynchronousChannelGroup group) {
        if (!(group instanceof AsynchronousChannelGroup)) {
            throw new RuntimeException("invalid class");
        }
        return (AsynchronousChannelGroup)group;
    }
}

