/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.socket.plugin;

import java.nio.channels.AsynchronousChannelGroup;
import org.miaixz.bus.socket.Session;
import org.miaixz.bus.socket.Status;
import org.miaixz.bus.socket.accord.AioClient;
import org.miaixz.bus.socket.plugin.AbstractPlugin;

class ReconnectPlugin
extends AbstractPlugin {
    private final AsynchronousChannelGroup asynchronousChannelGroup;
    private final AioClient client;
    private boolean shutdown = false;

    public ReconnectPlugin(AioClient client) {
        this(client, null);
    }

    public ReconnectPlugin(AioClient client, AsynchronousChannelGroup asynchronousChannelGroup) {
        this.client = client;
        this.asynchronousChannelGroup = asynchronousChannelGroup;
    }

    @Override
    public void stateEvent(Status status, Session session, Throwable throwable) {
        if (status != Status.SESSION_CLOSED || this.shutdown) {
            return;
        }
        try {
            if (this.asynchronousChannelGroup == null) {
                this.client.start();
            } else {
                this.client.start(this.asynchronousChannelGroup);
            }
        }
        catch (Exception e) {
            this.shutdown = true;
            e.printStackTrace();
        }
    }

    public void shutdown() {
        this.shutdown = true;
    }
}

