/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.socket.plugin;

import java.nio.channels.AsynchronousSocketChannel;
import org.miaixz.bus.socket.Plugin;
import org.miaixz.bus.socket.Session;
import org.miaixz.bus.socket.Status;

public abstract class AbstractPlugin<T>
implements Plugin<T> {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

    public static String toHex(byte b) {
        char[] buf = new char[2];
        for (int i = 0; i < buf.length; ++i) {
            buf[1 - i] = DIGITS[b & 0xF];
            b = (byte)(b >>> 4);
        }
        return new String(buf);
    }

    public static String toHexString(byte[] bytes) {
        int i;
        StringBuilder buffer = new StringBuilder(bytes.length);
        buffer.append("\r\n\t\t   0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f\r\n");
        int startIndex = 0;
        int column = 0;
        block4: for (i = 0; i < bytes.length; ++i) {
            column = i % 16;
            switch (column) {
                case 0: {
                    startIndex = i;
                    buffer.append(AbstractPlugin.fixHexString(Integer.toHexString(i), 8)).append(": ");
                    buffer.append(AbstractPlugin.toHex(bytes[i]));
                    buffer.append(' ');
                    continue block4;
                }
                case 15: {
                    buffer.append(AbstractPlugin.toHex(bytes[i]));
                    buffer.append(" ; ");
                    buffer.append(AbstractPlugin.filterString(bytes, startIndex, column + 1));
                    buffer.append("\r\n");
                    continue block4;
                }
                default: {
                    buffer.append(AbstractPlugin.toHex(bytes[i]));
                    buffer.append(' ');
                }
            }
        }
        if (column != 15) {
            for (i = 0; i < 15 - column; ++i) {
                buffer.append("   ");
            }
            buffer.append("; ").append(AbstractPlugin.filterString(bytes, startIndex, column + 1));
            buffer.append("\r\n");
        }
        return buffer.toString();
    }

    private static String filterString(byte[] bytes, int offset, int count) {
        byte[] buffer = new byte[count];
        System.arraycopy(bytes, offset, buffer, 0, count);
        for (int i = 0; i < count; ++i) {
            if (buffer[i] < 0 || buffer[i] > 31) continue;
            buffer[i] = 46;
        }
        return new String(buffer);
    }

    private static String fixHexString(String hexStr, int length) {
        if (hexStr == null || hexStr.length() == 0) {
            return "00000000h";
        }
        StringBuilder buf = new StringBuilder(length);
        int strLen = hexStr.length();
        for (int i = 0; i < length - strLen; ++i) {
            buf.append('0');
        }
        buf.append(hexStr).append('h');
        return buf.toString();
    }

    @Override
    public boolean process(Session session, T data) {
        return true;
    }

    @Override
    public void stateEvent(Status status, Session session, Throwable throwable) {
    }

    @Override
    public AsynchronousSocketChannel shouldAccept(AsynchronousSocketChannel channel) {
        return channel;
    }

    @Override
    public void afterRead(Session session, int readSize) {
    }

    @Override
    public void afterWrite(Session session, int writeSize) {
    }

    @Override
    public void beforeRead(Session session) {
    }

    @Override
    public void beforeWrite(Session session) {
    }
}

