/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.socket.plugin;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.miaixz.bus.core.center.date.Formatter;
import org.miaixz.bus.core.xyz.ByteKit;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.socket.metric.channels.AsynchronousSocketChannelProxy;
import org.miaixz.bus.socket.metric.channels.UnsupportedAsynchronousSocketChannel;
import org.miaixz.bus.socket.plugin.AbstractPlugin;

public class StreamMonitorPlugin<T>
extends AbstractPlugin<T> {
    public static final BiConsumer<AsynchronousSocketChannel, byte[]> BLUE_HEX_INPUT_STREAM = (channel, bytes) -> {
        try {
            Logger.info((String)("\u001b[34m" + Formatter.NORM_DATETIME_MS_FORMAT.format(new Date()) + " [ " + String.valueOf(channel.getRemoteAddress()) + " --> " + String.valueOf(channel.getLocalAddress()) + " ] [ read: " + ((byte[])bytes).length + " bytes ]" + ByteKit.byteArrayToHexString((byte[])bytes) + "\u001b[0m"), (Object[])new Object[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    };
    public static final BiConsumer<AsynchronousSocketChannel, byte[]> RED_HEX_OUTPUT_STREAM = (channel, bytes) -> {
        try {
            Logger.info((String)("\u001b[31m" + Formatter.NORM_DATETIME_MS_FORMAT.format(new Date()) + " [ " + String.valueOf(channel.getLocalAddress()) + " --> " + String.valueOf(channel.getRemoteAddress()) + " ] [ write: " + ((byte[])bytes).length + " bytes ]" + ByteKit.byteArrayToHexString((byte[])bytes) + "\u001b[0m"), (Object[])new Object[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    };
    public static final BiConsumer<AsynchronousSocketChannel, byte[]> BLUE_TEXT_INPUT_STREAM = (channel, bytes) -> {
        try {
            Logger.info((String)("\u001b[34m" + Formatter.NORM_DATETIME_MS_FORMAT.format(new Date()) + " [ " + String.valueOf(channel.getRemoteAddress()) + " --> " + String.valueOf(channel.getLocalAddress()) + " ] [ read: " + ((byte[])bytes).length + " bytes ]\r\n" + new String((byte[])bytes) + "\u001b[0m"), (Object[])new Object[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    };
    public static final BiConsumer<AsynchronousSocketChannel, byte[]> RED_TEXT_OUTPUT_STREAM = (channel, bytes) -> {
        try {
            Logger.info((String)("\u001b[31m" + Formatter.NORM_DATETIME_MS_FORMAT.format(new Date()) + " [ " + String.valueOf(channel.getLocalAddress()) + " --> " + String.valueOf(channel.getRemoteAddress()) + " ] [ write: " + ((byte[])bytes).length + " bytes ]\r\n" + new String((byte[])bytes) + "\u001b[0m"), (Object[])new Object[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    };
    private final BiConsumer<AsynchronousSocketChannel, byte[]> inputStreamConsumer;
    private final BiConsumer<AsynchronousSocketChannel, byte[]> outputStreamConsumer;

    public StreamMonitorPlugin() {
        this(BLUE_HEX_INPUT_STREAM, RED_HEX_OUTPUT_STREAM);
    }

    public StreamMonitorPlugin(BiConsumer<AsynchronousSocketChannel, byte[]> inputStreamConsumer, BiConsumer<AsynchronousSocketChannel, byte[]> outputStreamConsumer) {
        this.inputStreamConsumer = Objects.requireNonNull(inputStreamConsumer);
        this.outputStreamConsumer = Objects.requireNonNull(outputStreamConsumer);
    }

    @Override
    public AsynchronousSocketChannel shouldAccept(AsynchronousSocketChannel channel) {
        return new StreamMonitorAsynchronousSocketChannel(channel);
    }

    class StreamMonitorAsynchronousSocketChannel
    extends AsynchronousSocketChannelProxy {
        public StreamMonitorAsynchronousSocketChannel(AsynchronousSocketChannel asynchronousSocketChannel) {
            super(asynchronousSocketChannel);
        }

        @Override
        public <A> void read(ByteBuffer dst, long timeout, TimeUnit unit, A attachment, CompletionHandler<Integer, ? super A> handler) {
            super.read(dst, timeout, unit, attachment, new MonitorCompletionHandler<A>(this, handler, StreamMonitorPlugin.this.inputStreamConsumer, dst));
        }

        @Override
        public <A> void write(ByteBuffer src, long timeout, TimeUnit unit, A attachment, CompletionHandler<Integer, ? super A> handler) {
            super.write(src, timeout, unit, attachment, new MonitorCompletionHandler<A>(this, handler, StreamMonitorPlugin.this.outputStreamConsumer, src));
        }
    }

    static class ConsoleColors {
        public static final String RESET = "\u001b[0m";
        public static final String BLUE = "\u001b[34m";
        public static final String RED = "\u001b[31m";

        ConsoleColors() {
        }
    }

    static class MonitorCompletionHandler<A>
    implements CompletionHandler<Integer, A> {
        CompletionHandler<Integer, A> handler;
        BiConsumer<AsynchronousSocketChannel, byte[]> consumer;
        ByteBuffer buffer;
        AsynchronousSocketChannel channel;

        public MonitorCompletionHandler(final AsynchronousSocketChannel channel, CompletionHandler<Integer, A> handler, BiConsumer<AsynchronousSocketChannel, byte[]> consumer, ByteBuffer buffer) {
            this.channel = new UnsupportedAsynchronousSocketChannel(this, channel){

                @Override
                public SocketAddress getRemoteAddress() throws IOException {
                    return channel.getRemoteAddress();
                }

                @Override
                public SocketAddress getLocalAddress() throws IOException {
                    return channel.getLocalAddress();
                }
            };
            this.handler = handler;
            this.consumer = consumer;
            this.buffer = buffer;
        }

        @Override
        public void completed(Integer result, A attachment) {
            if (result > 0) {
                byte[] bytes = new byte[result.intValue()];
                this.buffer.position(this.buffer.position() - result);
                this.buffer.get(bytes);
                this.consumer.accept(this.channel, bytes);
            }
            this.handler.completed(result, attachment);
        }

        @Override
        public void failed(Throwable exc, A attachment) {
            this.handler.failed(exc, attachment);
        }
    }
}

