/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.spring.banner;

import java.io.PrintStream;
import org.miaixz.bus.core.Version;
import org.miaixz.bus.spring.BusXBuilder;
import org.springframework.boot.Banner;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.ansi.AnsiColor;
import org.springframework.boot.ansi.AnsiOutput;
import org.springframework.core.env.Environment;

public class BusBanner
implements Banner {
    public void printBanner(Environment environment, Class<?> sourceClass, PrintStream printStream) {
        printStream.println();
        for (String line : BusXBuilder.BUS_BANNER) {
            printStream.println(AnsiOutput.toString((Object[])new Object[]{AnsiColor.BRIGHT_GREEN, line}));
        }
        String springVersion = " :: Spring Boot :: " + String.format("(v%s)", SpringBootVersion.getVersion());
        String busVersion = " :: Bus Boot :: " + String.format("(v%s)", Version.all());
        StringBuilder padding = new StringBuilder();
        while (padding.length() < 70 - (springVersion.length() + busVersion.length())) {
            padding.append(" ");
        }
        printStream.println(AnsiOutput.toString((Object[])new Object[]{AnsiColor.BRIGHT_MAGENTA, springVersion, padding.toString(), AnsiColor.BRIGHT_MAGENTA, busVersion}));
        printStream.println();
    }
}

