/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.spring;

import java.util.Properties;
import org.miaixz.bus.core.Version;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

@Order(value=2147483547)
public class Configurable
implements EnvironmentPostProcessor {
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        System.setProperty("user.timezone", "Asia/Shanghai");
        PropertiesPropertySource propertySource = new PropertiesPropertySource("GenieBuilder", this.getProperties());
        environment.getPropertySources().addLast((PropertySource)propertySource);
        environment.setRequiredProperties(new String[]{"spring.application.name"});
    }

    protected Properties getProperties() {
        Properties properties = new Properties();
        String version = Version.all();
        properties.setProperty("bus-boot.version", version);
        properties.setProperty("bus-boot.formatted-version", version.isEmpty() ? "" : String.format(" (v%s)", version));
        return properties;
    }
}

