/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.bridge;

import jakarta.annotation.Resource;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.setting.Builder;
import org.miaixz.bus.starter.bridge.BridgeProperties;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.core.Ordered;
import org.springframework.core.env.PropertySource;

public class BridgePropertyLoader
implements PropertySourceLoader,
Ordered {
    @Resource
    private BridgeProperties properties;
    private String profiles = null;

    public String[] getFileExtensions() {
        return new String[]{"properties", "yml", "yaml"};
    }

    public List<PropertySource<?>> load(String name, org.springframework.core.io.Resource resource) throws IOException {
        Properties property = new Properties();
        if (name.contains("properties")) {
            property.load(resource.getInputStream());
        } else {
            YamlPropertiesFactoryBean bean = new YamlPropertiesFactoryBean();
            bean.setResources(new org.springframework.core.io.Resource[]{resource});
            property = bean.getObject();
        }
        if (this.profiles == null) {
            this.profiles = property.getProperty("spring.profiles.active");
        } else {
            Logger.info((String)("spring.profiles.active = " + this.profiles + ",ignore load remote config"), (Object[])new Object[0]);
        }
        if (this.profiles == null) {
            this.mergeProperties(property);
            OriginTrackedMapPropertySource props = new OriginTrackedMapPropertySource(name, (Map)property);
            return Collections.singletonList(props);
        }
        return Collections.singletonList(new OriginTrackedMapPropertySource(name, (Map)property));
    }

    public int getOrder() {
        return -2147483637;
    }

    public void mergeProperties(Properties properties) {
        String url = String.format("%s?method=%s&v=%s&format=%s&appKey=%s&profile=%s", this.properties.getUrl(), this.properties.getMethod(), this.properties.getVersion(), this.properties.getFormat(), this.properties.getAppKey(), this.properties.getProfile());
        Logger.debug((String)("fetch configs url:" + url), (Object[])new Object[0]);
        String response = Httpx.get((String)url);
        Map map = (Map)JsonKit.toMap((String)response).get("data");
        if (map == null) {
            throw new RuntimeException("fetch remote config error!");
        }
        for (Map.Entry entry : map.entrySet()) {
            properties.setProperty((String)entry.getKey(), entry.getValue().toString());
        }
        Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            String value = entry.getValue().toString();
            if (!value.contains("${")) continue;
            value = Builder.replaceYamlValue((Properties)properties, (String)value);
            properties.setProperty(entry.getKey().toString(), value);
        }
    }
}

