/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.elastic;

import jakarta.annotation.Resource;
import java.util.List;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.miaixz.bus.base.normal.Consts;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.starter.elastic.ElasticProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={ElasticProperties.class})
public class ElasticConfiguration {
    @Resource
    private ElasticProperties elasticProperties;

    @Bean
    @ConditionalOnClass
    public RestClientBuilder restClientBuilder() {
        if (CollKit.isEmpty(this.elasticProperties.getHostList())) {
            Logger.error((String)"[ElasticConfiguration.restClientBuilder] \u521d\u59cb\u5316 RestClient \u5931\u8d25: \u672a\u914d\u7f6e\u96c6\u7fa4\u4e3b\u673a\u4fe1\u606f", (Object[])new Object[0]);
            throw new InternalException("\u521d\u59cb\u5316 RestClient \u5931\u8d25: \u672a\u914d\u7f6e ElasticSearch \u96c6\u7fa4\u4e3b\u673a\u4fe1\u606f");
        }
        HttpHost[] hosts = (HttpHost[])this.elasticProperties.getHostList().stream().map(this::buildHttpHost).toArray(HttpHost[]::new);
        return RestClient.builder((HttpHost[])hosts);
    }

    private HttpHost buildHttpHost(String host) {
        if (StringKit.isBlank((CharSequence)host) || !host.contains(":")) {
            throw new InternalException("ElasticSearch\u96c6\u7fa4\u8282\u70b9\u4fe1\u606f\u914d\u7f6e\u9519\u8bef, \u6b63\u786e\u683c\u5f0f[ ip1:port,ip2:port... ]");
        }
        List hostPort = StringKit.split((CharSequence)host, (CharSequence)":");
        return new HttpHost((String)hostPort.get(Consts.INTEGER_ZERO), Integer.parseInt((String)hostPort.get(Consts.INTEGER_ONE)), this.elasticProperties.getSchema());
    }

    @Bean(name={"highLevelClient"})
    public RestHighLevelClient highLevelClient(RestClientBuilder restClientBuilder) {
        restClientBuilder.setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(this.elasticProperties.getConnectTimeout()).setSocketTimeout(this.elasticProperties.getSocketTimeout()).setConnectionRequestTimeout(this.elasticProperties.getConnectionRequestTimeout()));
        restClientBuilder.setHttpClientConfigCallback(httpAsyncClientBuilder -> httpAsyncClientBuilder.setMaxConnTotal(this.elasticProperties.getMaxConnectTotal()).setMaxConnPerRoute(this.elasticProperties.getMaxConnectPerRoute()));
        return new RestHighLevelClient(restClientBuilder);
    }
}

