/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.elastic;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="extend.elastic")
public class ElasticProperties {
    private String hosts;
    private String schema = "http";
    private int connectTimeout = 6000;
    private int socketTimeout = 60000;
    private int connectionRequestTimeout = 6000;
    private int maxConnectTotal = 2000;
    private int maxConnectPerRoute = 500;
    private List<String> hostList;

    public List<String> getHostList() {
        if (null == this.hosts || "".equalsIgnoreCase(this.hosts.trim())) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.hosts.split(","));
    }

    public String getHosts() {
        return this.hosts;
    }

    public String getSchema() {
        return this.schema;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public int getMaxConnectTotal() {
        return this.maxConnectTotal;
    }

    public int getMaxConnectPerRoute() {
        return this.maxConnectPerRoute;
    }

    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public void setMaxConnectTotal(int maxConnectTotal) {
        this.maxConnectTotal = maxConnectTotal;
    }

    public void setMaxConnectPerRoute(int maxConnectPerRoute) {
        this.maxConnectPerRoute = maxConnectPerRoute;
    }

    public void setHostList(List<String> hostList) {
        this.hostList = hostList;
    }
}

