/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.image;

import jakarta.annotation.Resource;
import org.miaixz.bus.core.xyz.ResourceKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.image.Args;
import org.miaixz.bus.image.Centre;
import org.miaixz.bus.image.Efforts;
import org.miaixz.bus.image.Node;
import org.miaixz.bus.image.nimble.opencv.OpenCVNativeLoader;
import org.miaixz.bus.image.plugin.StoreSCP;
import org.miaixz.bus.starter.image.ImageProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={ImageProperties.class})
public class ImageConfiguration {
    @Resource
    ImageProperties properties;
    @Resource
    Efforts efforts;

    @Bean(initMethod="start", destroyMethod="stop")
    public Centre onStoreSCP() {
        if (this.properties.isOpencv()) {
            new OpenCVNativeLoader().init();
        }
        if (this.properties.isServer()) {
            if (StringKit.isEmpty((CharSequence)this.properties.getNode().getAeTitle())) {
                throw new NullPointerException("The aeTitle cannot be null.");
            }
            if (StringKit.isEmpty((CharSequence)this.properties.getNode().getHost())) {
                throw new NullPointerException("The host cannot be null.");
            }
            if (StringKit.isEmpty((CharSequence)this.properties.getNode().getPort())) {
                throw new NullPointerException("The port cannot be null.");
            }
            Args args = new Args(true);
            if (StringKit.isNotEmpty((CharSequence)this.properties.getNode().getRelClass())) {
                args.setExtendSopClassesURL(ResourceKit.getResourceUrl((String)this.properties.getNode().getRelClass(), ImageConfiguration.class));
            }
            if (StringKit.isNotEmpty((CharSequence)this.properties.getNode().getRelClass())) {
                args.setExtendSopClassesURL(ResourceKit.getResourceUrl((String)this.properties.getNode().getRelClass(), ImageConfiguration.class));
            }
            if (StringKit.isNotEmpty((CharSequence)this.properties.getNode().getSopClass())) {
                args.setTransferCapabilityFile(ResourceKit.getResourceUrl((String)this.properties.getNode().getSopClass(), ImageConfiguration.class));
            }
            if (StringKit.isNotEmpty((CharSequence)this.properties.getNode().getTcsClass())) {
                args.setExtendStorageSOPClass(ResourceKit.getResourceUrl((String)this.properties.getNode().getTcsClass(), ImageConfiguration.class));
            }
            return Centre.builder().args(args).efforts(this.efforts).node(new Node(this.properties.getNode().getAeTitle(), this.properties.getNode().getHost(), Integer.valueOf(this.properties.getNode().getPort()))).storeSCP(new StoreSCP(this.properties.getDcmPath())).build();
        }
        return null;
    }
}

