/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.jdbc;

import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.starter.jdbc.DataSource;
import org.miaixz.bus.starter.jdbc.DataSourceHolder;
import org.springframework.core.annotation.Order;

@Order(value=-1)
@Aspect
public class AspectjJdbcProxy {
    @Pointcut(value="@annotation(org.miaixz.bus.starter.jdbc.DataSource)||execution(* *(@org.miaixz.bus.starter.jdbc.DataSource (*), ..))")
    public void match() {
    }

    @Around(value="match()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Method method = ((MethodSignature)point.getSignature()).getMethod();
        DataSource dataSource = method.getAnnotation(DataSource.class);
        if (!StringKit.isEmptyIfString((Object)dataSource.value())) {
            dataSource = method.getDeclaringClass().getAnnotation(DataSource.class);
        }
        if (null != dataSource) {
            DataSourceHolder.setKey(dataSource.value());
            Logger.info((String)"Switch datasource to [{}] in method [{}]", (Object[])new Object[]{DataSourceHolder.getKey(), point.getSignature()});
        }
        Object object = point.proceed();
        DataSourceHolder.remove();
        Logger.info((String)"Restore datasource to [{}] in method [{}]", (Object[])new Object[]{DataSourceHolder.getKey(), point.getSignature()});
        return object;
    }
}

