/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.jdbc;

import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.starter.jdbc.DataSource;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

public class DataSourceHolder {
    private static final ThreadLocal<String> DATA_SOURCE_KEY = ThreadLocal.withInitial(() -> "dataSource");

    public static String getKey() {
        return DATA_SOURCE_KEY.get();
    }

    public static void setKey(String key) {
        DATA_SOURCE_KEY.set(key);
    }

    public static void remove() {
        DATA_SOURCE_KEY.remove();
    }

    @Order(value=-1)
    @Aspect
    @Component
    public class DataSourceSwitch {
        public DataSourceSwitch(DataSourceHolder this$0) {
        }

        @Pointcut(value="@annotation(org.miaixz.bus.starter.jdbc.DataSource)")
        public void switching() {
        }

        @Around(value="switching()")
        public Object around(ProceedingJoinPoint point) throws Throwable {
            Method method = ((MethodSignature)point.getSignature()).getMethod();
            DataSource dataSource = method.getAnnotation(DataSource.class);
            if (!StringKit.isEmptyIfString((Object)dataSource.value())) {
                dataSource = method.getDeclaringClass().getAnnotation(DataSource.class);
            }
            if (null != dataSource) {
                DataSourceHolder.setKey(dataSource.value());
                Logger.info((String)"Switch datasource to [{}] in method [{}]", (Object[])new Object[]{DataSourceHolder.getKey(), point.getSignature()});
            }
            Object object = point.proceed();
            DataSourceHolder.remove();
            Logger.info((String)"Restore datasource to [{}] in method [{}]", (Object[])new Object[]{DataSourceHolder.getKey(), point.getSignature()});
            return object;
        }
    }
}

