/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.jdbc;

import com.zaxxer.hikari.HikariDataSource;
import jakarta.annotation.Resource;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.miaixz.bus.core.lang.Algorithm;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.crypto.Builder;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.starter.jdbc.AspectjJdbcProxy;
import org.miaixz.bus.starter.jdbc.DynamicDataSource;
import org.miaixz.bus.starter.jdbc.JdbcProperties;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertyNameAliases;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@ConditionalOnClass(value={HikariDataSource.class})
@EnableConfigurationProperties(value={JdbcProperties.class})
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
@Import(value={AspectjJdbcProxy.class})
public class JdbcConfiguration {
    private static final ConfigurationPropertyNameAliases aliases = new ConfigurationPropertyNameAliases();
    private final Map<Object, Object> sourceMap = new HashMap<Object, Object>();
    @Resource
    JdbcProperties properties;

    @Bean
    @Primary
    public DynamicDataSource dataSource() {
        Map<String, Object> defaultConfig = this.beanToMap(this.properties);
        DataSource defaultDatasource = this.bind(defaultConfig);
        this.sourceMap.put("dataSource", defaultDatasource);
        if (ObjectKit.isNotEmpty(this.properties.getMulti())) {
            Logger.info((String)"Enabled Multiple DataSource", (Object[])new Object[0]);
            List<JdbcProperties> list = this.properties.getMulti();
            for (int i = 0; i < list.size(); ++i) {
                Map<String, Object> config = this.beanToMap(list.get(i));
                if (((Boolean)config.getOrDefault("extend", Boolean.TRUE)).booleanValue()) {
                    HashMap<String, Object> properties = new HashMap<String, Object>(defaultConfig);
                    properties.putAll(config);
                }
                this.sourceMap.put(config.get("key").toString(), this.bind(config));
            }
        }
        DynamicDataSource dataSource = new DynamicDataSource();
        dataSource.setDefaultTargetDataSource(defaultDatasource);
        dataSource.setTargetDataSources(this.sourceMap);
        return dataSource;
    }

    @Bean
    public DataSourceTransactionManager transactionManager(DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    private DataSource bind(Map<String, Object> map) {
        String type = StringKit.toString((Object)map.get("type"));
        if (StringKit.isEmpty((CharSequence)type)) {
            throw new InternalException("The database type is empty");
        }
        try {
            return this.bind(Class.forName(type), map);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot resolve class with type: " + type);
        }
    }

    private <T> Map<String, Object> beanToMap(T bean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null != bean) {
            BeanMap beanMap = BeanMap.create(bean);
            for (Object key : beanMap.keySet()) {
                Object value = beanMap.get(key);
                if (StringKit.isNotEmpty((CharSequence)this.properties.getPrivateKey())) {
                    Logger.info((String)"The database connection is securely enabled", (Object[])new Object[0]);
                    if ("url".equals(key)) {
                        value = Builder.decrypt((String)Algorithm.AES.getValue(), (String)this.properties.getPrivateKey(), (String)value.toString(), (Charset)org.miaixz.bus.core.lang.Charset.UTF_8);
                        beanMap.put((Object)"url", value);
                    } else if ("username".equals(key)) {
                        value = Builder.decrypt((String)Algorithm.AES.getValue(), (String)this.properties.getPrivateKey(), (String)value.toString(), (Charset)org.miaixz.bus.core.lang.Charset.UTF_8);
                        beanMap.put((Object)"username", value);
                    } else if ("password".equals(key)) {
                        value = Builder.decrypt((String)Algorithm.AES.getValue(), (String)this.properties.getPrivateKey(), (String)value.toString(), (Charset)org.miaixz.bus.core.lang.Charset.UTF_8);
                        beanMap.put((Object)"password", value);
                    }
                }
                map.put(StringKit.toString(key), value);
            }
        }
        return map;
    }

    private void bind(DataSource result, Map properties) {
        MapConfigurationPropertySource source = new MapConfigurationPropertySource(properties);
        Binder binder = new Binder(new ConfigurationPropertySource[]{source.withAliases(aliases)});
        binder.bind(ConfigurationPropertyName.EMPTY, Bindable.ofInstance((Object)result));
    }

    private <T extends DataSource> T bind(Class<T> clazz, Map properties) {
        MapConfigurationPropertySource source = new MapConfigurationPropertySource(properties);
        Binder binder = new Binder(new ConfigurationPropertySource[]{source.withAliases(aliases)});
        return (T)((DataSource)binder.bind(ConfigurationPropertyName.EMPTY, Bindable.of(clazz)).get());
    }

    static {
        aliases.addAliases("url", new String[]{"jdbc-url"});
        aliases.addAliases("username", new String[]{"user"});
    }
}

