/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.mapper;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;
import org.apache.ibatis.session.SqlSessionFactory;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.mapper.builder.MapperBuilder;
import org.miaixz.bus.mapper.entity.Property;
import org.miaixz.bus.spring.PlaceBinder;
import org.miaixz.bus.starter.mapper.MapperFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.env.Environment;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class ClassPathMapperScanner
extends ClassPathBeanDefinitionScanner {
    private boolean addToConfig = true;
    private SqlSessionFactory sqlSessionFactory;
    private SqlSessionTemplate sqlSessionTemplate;
    private String sqlSessionTemplateBeanName;
    private String sqlSessionFactoryBeanName;
    private Class<? extends Annotation> annotationClass;
    private Class<?> markerInterface;
    private MapperBuilder mapperBuilder;
    private String mapperBuilderBeanName;
    private MapperFactoryBean<?> mapperFactoryBean = new MapperFactoryBean();

    public ClassPathMapperScanner(BeanDefinitionRegistry registry) {
        super(registry, false);
    }

    public void registerFilters() {
        boolean acceptAllInterfaces = true;
        if (this.annotationClass != null) {
            this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(this.annotationClass));
            acceptAllInterfaces = false;
        }
        if (this.markerInterface != null) {
            this.addIncludeFilter((TypeFilter)new AssignableTypeFilter(this, this.markerInterface){

                protected boolean matchClassName(String className) {
                    return false;
                }
            });
            acceptAllInterfaces = false;
        }
        if (acceptAllInterfaces) {
            this.addIncludeFilter((metadataReader, metadataReaderFactory) -> true);
        }
        this.addExcludeFilter((metadataReader, metadataReaderFactory) -> {
            String className = metadataReader.getClassMetadata().getClassName();
            if (className.endsWith("package-info")) {
                return true;
            }
            return metadataReader.getAnnotationMetadata().hasAnnotation("annotation.mapper.org.miaixz.bus.RegisterMapper");
        });
    }

    public Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        Set beanDefinitions = super.doScan(basePackages);
        if (beanDefinitions.isEmpty()) {
            Logger.warn((String)("No MyBatis mapper was found in '" + Arrays.toString(basePackages) + "' package. Please check your configuration."), (Object[])new Object[0]);
        } else {
            this.processBeanDefinitions(beanDefinitions);
        }
        return beanDefinitions;
    }

    private void processBeanDefinitions(Set<BeanDefinitionHolder> beanDefinitions) {
        for (BeanDefinitionHolder holder : beanDefinitions) {
            GenericBeanDefinition definition = (GenericBeanDefinition)holder.getBeanDefinition();
            if (Logger.isDebug()) {
                Logger.debug((String)("Creating MapperFactoryBean with name '" + holder.getBeanName() + "' and '" + definition.getBeanClassName() + "' mapperInterface"), (Object[])new Object[0]);
            }
            definition.getConstructorArgumentValues().addGenericArgumentValue((Object)definition.getBeanClassName());
            definition.setBeanClass(((Object)this.mapperFactoryBean).getClass());
            if (StringKit.hasText((String)this.mapperBuilderBeanName)) {
                definition.getPropertyValues().add("mapperBuilder", (Object)new RuntimeBeanReference(this.mapperBuilderBeanName));
            } else {
                if (this.mapperBuilder == null) {
                    this.mapperBuilder = new MapperBuilder();
                }
                definition.getPropertyValues().add("mapperBuilder", (Object)this.mapperBuilder);
            }
            definition.getPropertyValues().add("addToConfig", (Object)this.addToConfig);
            boolean explicitFactoryUsed = false;
            if (StringKit.hasText((String)this.sqlSessionFactoryBeanName)) {
                definition.getPropertyValues().add("sqlSessionFactory", (Object)new RuntimeBeanReference(this.sqlSessionFactoryBeanName));
                explicitFactoryUsed = true;
            } else if (this.sqlSessionFactory != null) {
                definition.getPropertyValues().add("sqlSessionFactory", (Object)this.sqlSessionFactory);
                explicitFactoryUsed = true;
            }
            if (StringKit.hasText((String)this.sqlSessionTemplateBeanName)) {
                if (explicitFactoryUsed) {
                    Logger.warn((String)"Cannot use both: sqlSessionTemplate and sqlSessionFactory together. sqlSessionFactory is ignored.", (Object[])new Object[0]);
                }
                definition.getPropertyValues().add("sqlSessionTemplate", (Object)new RuntimeBeanReference(this.sqlSessionTemplateBeanName));
                explicitFactoryUsed = true;
            } else if (this.sqlSessionTemplate != null) {
                if (explicitFactoryUsed) {
                    Logger.warn((String)"Cannot use both: sqlSessionTemplate and sqlSessionFactory together. sqlSessionFactory is ignored.", (Object[])new Object[0]);
                }
                definition.getPropertyValues().add("sqlSessionTemplate", (Object)this.sqlSessionTemplate);
                explicitFactoryUsed = true;
            }
            if (explicitFactoryUsed) continue;
            if (Logger.isDebug()) {
                Logger.debug((String)("Enabling autowire by type for MapperFactoryBean with name '" + holder.getBeanName() + "'."), (Object[])new Object[0]);
            }
            definition.setAutowireMode(2);
        }
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        return beanDefinition.getMetadata().isInterface() && beanDefinition.getMetadata().isIndependent();
    }

    protected boolean checkCandidate(String beanName, BeanDefinition beanDefinition) {
        if (super.checkCandidate(beanName, beanDefinition)) {
            return true;
        }
        Logger.warn((String)("Skipping MapperFactoryBean with name '" + beanName + "' and '" + beanDefinition.getBeanClassName() + "' mapperInterface. Bean already defined with the same name!"), (Object[])new Object[0]);
        return false;
    }

    public MapperBuilder getMapperBuilder() {
        return this.mapperBuilder;
    }

    public void setMapperBuilder(MapperBuilder mapperBuilder) {
        this.mapperBuilder = mapperBuilder;
    }

    public void setAddToConfig(boolean addToConfig) {
        this.addToConfig = addToConfig;
    }

    public void setAnnotationClass(Class<? extends Annotation> annotationClass) {
        this.annotationClass = annotationClass;
    }

    public void setConfig(Property property) {
        if (this.mapperBuilder == null) {
            this.mapperBuilder = new MapperBuilder();
        }
        this.mapperBuilder.setConfig(property);
    }

    public void setMapperFactoryBean(MapperFactoryBean<?> mapperFactoryBean) {
        this.mapperFactoryBean = mapperFactoryBean != null ? mapperFactoryBean : new MapperFactoryBean();
    }

    public void setMapperBuilderBeanName(String mapperBuilderBeanName) {
        this.mapperBuilderBeanName = mapperBuilderBeanName;
    }

    public void setMapperProperties(Environment environment) {
        try {
            Property property = (Property)PlaceBinder.bind((Environment)environment, Property.class, (String)"extend.mybatis");
            if (this.mapperBuilder == null) {
                this.mapperBuilder = new MapperBuilder();
            }
            if (property != null) {
                this.mapperBuilder.setConfig(property);
            }
        }
        catch (Exception e) {
            Logger.warn((String)"\u53ea\u6709 Spring Boot \u73af\u5883\u4e2d\u53ef\u4ee5\u901a\u8fc7 Environment(\u914d\u7f6e\u6587\u4ef6,\u73af\u5883\u53d8\u91cf,\u8fd0\u884c\u53c2\u6570\u7b49\u65b9\u5f0f) \u914d\u7f6e\u901a\u7528 Mapper\uff0c\u5176\u4ed6\u73af\u5883\u8bf7\u901a\u8fc7 @EnableMapper \u6ce8\u89e3\u4e2d\u7684 mapperBuilderRef \u6216 properties \u53c2\u6570\u8fdb\u884c\u914d\u7f6e!\u5f53\u7136,\u5982\u679c\u4f60\u4f7f\u7528 org.miaixz.bus..mapper.Property \u914d\u7f6e\u7684\u901a\u7528 Mapper\uff0c\u53ef\u4ee5\u5ffd\u7565\u8be5\u8b66\u544a!", (Object[])new Object[]{e});
        }
    }

    public void setMapperProperties(String[] properties) {
        if (this.mapperBuilder == null) {
            this.mapperBuilder = new MapperBuilder();
        }
        Properties props = new Properties();
        for (String property : properties) {
            int index = (property = property.trim()).indexOf("=");
            if (index < 0) {
                throw new InternalException("\u901a\u8fc7 @EnableMapper \u6ce8\u89e3\u7684 properties \u53c2\u6570\u914d\u7f6e\u51fa\u9519:" + property + " !\n\u8bf7\u4fdd\u8bc1\u914d\u7f6e\u9879\u6309 properties \u6587\u4ef6\u683c\u5f0f\u8981\u6c42\u8fdb\u884c\u914d\u7f6e\uff0c\u4f8b\u5982\uff1a\nproperties = {\n\t\"mappers=mapper.org.miaixz.bus.Mapper\",\n\t\"notEmpty=true\"\n}");
            }
            props.put(property.substring(0, index).trim(), property.substring(index + 1).trim());
        }
        this.mapperBuilder.setProperties(props);
    }

    public void setMarkerInterface(Class<?> markerInterface) {
        this.markerInterface = markerInterface;
    }

    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    public void setSqlSessionFactoryBeanName(String sqlSessionFactoryBeanName) {
        this.sqlSessionFactoryBeanName = sqlSessionFactoryBeanName;
    }

    public void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        this.sqlSessionTemplate = sqlSessionTemplate;
    }

    public void setSqlSessionTemplateBeanName(String sqlSessionTemplateBeanName) {
        this.sqlSessionTemplateBeanName = sqlSessionTemplateBeanName;
    }
}

