/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

@ConfigurationProperties(prefix="extend.mybatis")
public class MybatisProperties {
    private static final ResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
    private String[] basePackages;
    private String configLocation;
    private String[] mapperLocations;
    private String typeAliasesPackage;
    private Class<?> typeAliasesSuperType;
    private String typeHandlersPackage;
    private boolean checkConfigLocation = false;
    private ExecutorType executorType;
    private Properties configurationProperties;
    @NestedConfigurationProperty
    private Configuration configuration;
    private String params;
    private String autoDelimitKeywords;
    private String reasonable;
    private String supportMethodsArguments;

    public Resource[] resolveMapperLocations() {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (this.mapperLocations != null) {
            for (String mapperLocation : this.mapperLocations) {
                resources.addAll(Arrays.asList(this.getResources(mapperLocation)));
            }
        }
        return resources.toArray(new Resource[resources.size()]);
    }

    private Resource[] getResources(String location) {
        try {
            return resourceResolver.getResources(location);
        }
        catch (IOException e) {
            return new Resource[0];
        }
    }

    public String[] getBasePackages() {
        return this.basePackages;
    }

    public String getConfigLocation() {
        return this.configLocation;
    }

    public String[] getMapperLocations() {
        return this.mapperLocations;
    }

    public String getTypeAliasesPackage() {
        return this.typeAliasesPackage;
    }

    public Class<?> getTypeAliasesSuperType() {
        return this.typeAliasesSuperType;
    }

    public String getTypeHandlersPackage() {
        return this.typeHandlersPackage;
    }

    public boolean isCheckConfigLocation() {
        return this.checkConfigLocation;
    }

    public ExecutorType getExecutorType() {
        return this.executorType;
    }

    public Properties getConfigurationProperties() {
        return this.configurationProperties;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String getParams() {
        return this.params;
    }

    public String getAutoDelimitKeywords() {
        return this.autoDelimitKeywords;
    }

    public String getReasonable() {
        return this.reasonable;
    }

    public String getSupportMethodsArguments() {
        return this.supportMethodsArguments;
    }

    public void setBasePackages(String[] basePackages) {
        this.basePackages = basePackages;
    }

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    public void setMapperLocations(String[] mapperLocations) {
        this.mapperLocations = mapperLocations;
    }

    public void setTypeAliasesPackage(String typeAliasesPackage) {
        this.typeAliasesPackage = typeAliasesPackage;
    }

    public void setTypeAliasesSuperType(Class<?> typeAliasesSuperType) {
        this.typeAliasesSuperType = typeAliasesSuperType;
    }

    public void setTypeHandlersPackage(String typeHandlersPackage) {
        this.typeHandlersPackage = typeHandlersPackage;
    }

    public void setCheckConfigLocation(boolean checkConfigLocation) {
        this.checkConfigLocation = checkConfigLocation;
    }

    public void setExecutorType(ExecutorType executorType) {
        this.executorType = executorType;
    }

    public void setConfigurationProperties(Properties configurationProperties) {
        this.configurationProperties = configurationProperties;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public void setAutoDelimitKeywords(String autoDelimitKeywords) {
        this.autoDelimitKeywords = autoDelimitKeywords;
    }

    public void setReasonable(String reasonable) {
        this.reasonable = reasonable;
    }

    public void setSupportMethodsArguments(String supportMethodsArguments) {
        this.supportMethodsArguments = supportMethodsArguments;
    }
}

