/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.oauth;

import org.miaixz.bus.cache.metric.ExtendCache;
import org.miaixz.bus.oauth.cache.OauthCache;
import org.miaixz.bus.starter.oauth.AuthProperties;
import org.miaixz.bus.starter.oauth.AuthProviderService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={AuthProperties.class})
public class AuthConfiguration {
    @Bean
    public AuthProviderService authProviderFactory(AuthProperties properties, ExtendCache extendCache) {
        return new AuthProviderService(properties, extendCache);
    }

    @Bean
    @ConditionalOnMissingBean(value={ExtendCache.class})
    @ConditionalOnProperty(name={"extend.oauth.cache.type"}, havingValue="default", matchIfMissing=true)
    public ExtendCache authCache() {
        return OauthCache.INSTANCE;
    }
}

