/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.oauth;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.miaixz.bus.cache.metric.ExtendCache;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.oauth.Context;
import org.miaixz.bus.oauth.Provider;
import org.miaixz.bus.oauth.Registry;
import org.miaixz.bus.oauth.cache.OauthCache;
import org.miaixz.bus.oauth.magic.ErrorCode;
import org.miaixz.bus.oauth.metric.afdian.AfDianProvider;
import org.miaixz.bus.oauth.metric.alipay.AlipayProvider;
import org.miaixz.bus.oauth.metric.aliyun.AliyunProvider;
import org.miaixz.bus.oauth.metric.amazon.AmazonProvider;
import org.miaixz.bus.oauth.metric.baidu.BaiduProvider;
import org.miaixz.bus.oauth.metric.coding.CodingProvider;
import org.miaixz.bus.oauth.metric.dingtalk.DingTalkProvider;
import org.miaixz.bus.oauth.metric.douyin.DouyinProvider;
import org.miaixz.bus.oauth.metric.eleme.ElemeProvider;
import org.miaixz.bus.oauth.metric.facebook.FacebookProvider;
import org.miaixz.bus.oauth.metric.feishu.FeishuProvider;
import org.miaixz.bus.oauth.metric.gitee.GiteeProvider;
import org.miaixz.bus.oauth.metric.github.GithubProvider;
import org.miaixz.bus.oauth.metric.gitlab.GitlabProvider;
import org.miaixz.bus.oauth.metric.google.GoogleProvider;
import org.miaixz.bus.oauth.metric.huawei.HuaweiProvider;
import org.miaixz.bus.oauth.metric.jd.JdProvider;
import org.miaixz.bus.oauth.metric.kujiale.KujialeProvider;
import org.miaixz.bus.oauth.metric.line.LineProvider;
import org.miaixz.bus.oauth.metric.linkedin.LinkedinProvider;
import org.miaixz.bus.oauth.metric.meituan.MeituanProvider;
import org.miaixz.bus.oauth.metric.mi.MiProvider;
import org.miaixz.bus.oauth.metric.microsoft.MicrosoftCnProvider;
import org.miaixz.bus.oauth.metric.microsoft.MicrosoftProvider;
import org.miaixz.bus.oauth.metric.okta.OktaProvider;
import org.miaixz.bus.oauth.metric.oschina.OschinaProvider;
import org.miaixz.bus.oauth.metric.pinterest.PinterestProvider;
import org.miaixz.bus.oauth.metric.proginn.ProginnProvider;
import org.miaixz.bus.oauth.metric.qq.QqProvider;
import org.miaixz.bus.oauth.metric.renren.RenrenProvider;
import org.miaixz.bus.oauth.metric.slack.SlackProvider;
import org.miaixz.bus.oauth.metric.stackoverflow.StackOverflowProvider;
import org.miaixz.bus.oauth.metric.taobao.TaobaoProvider;
import org.miaixz.bus.oauth.metric.teambition.TeambitionProvider;
import org.miaixz.bus.oauth.metric.toutiao.ToutiaoProvider;
import org.miaixz.bus.oauth.metric.twitter.TwitterProvider;
import org.miaixz.bus.oauth.metric.wechat.ee.WeChatEeQrcodeProvider;
import org.miaixz.bus.oauth.metric.wechat.ee.WeChatEeThirdQrcodeProvider;
import org.miaixz.bus.oauth.metric.wechat.ee.WeChatEeWebProvider;
import org.miaixz.bus.oauth.metric.wechat.mp.WeChatMpProvider;
import org.miaixz.bus.oauth.metric.wechat.open.WeChatOpenProvider;
import org.miaixz.bus.oauth.metric.weibo.WeiboProvider;
import org.miaixz.bus.oauth.metric.ximalaya.XimalayaProvider;
import org.miaixz.bus.starter.oauth.AuthProperties;

public class AuthProviderService {
    private static Map<Registry, Context> CACHE = new ConcurrentHashMap<Registry, Context>();
    public AuthProperties properties;
    public ExtendCache cache;

    public AuthProviderService(AuthProperties properties) {
        this(properties, (ExtendCache)OauthCache.INSTANCE);
    }

    public AuthProviderService(AuthProperties properties, ExtendCache cache) {
        this.properties = properties;
        this.cache = cache;
    }

    public static void register(Registry type, Context context) {
        if (CACHE.containsKey(type)) {
            throw new InternalException("\u91cd\u590d\u6ce8\u518c\u540c\u540d\u79f0\u7684\u7ec4\u4ef6\uff1a" + type.name());
        }
        CACHE.putIfAbsent(type, context);
    }

    public Provider require(Registry type) {
        Context context = CACHE.get(type);
        if (ObjectKit.isEmpty((Object)context)) {
            context = this.properties.getType().get(type);
        }
        if (Registry.AFDIAN.equals((Object)type)) {
            return new AfDianProvider(context, this.cache);
        }
        if (Registry.ALIPAY.equals((Object)type)) {
            return new AlipayProvider(context, this.cache);
        }
        if (Registry.ALIYUN.equals((Object)type)) {
            return new AliyunProvider(context, this.cache);
        }
        if (Registry.AMAZON.equals((Object)type)) {
            return new AmazonProvider(context, this.cache);
        }
        if (Registry.BAIDU.equals((Object)type)) {
            return new BaiduProvider(context, this.cache);
        }
        if (Registry.CODING.equals((Object)type)) {
            return new CodingProvider(context, this.cache);
        }
        if (Registry.DINGTALK.equals((Object)type)) {
            return new DingTalkProvider(context, this.cache);
        }
        if (Registry.DOUYIN.equals((Object)type)) {
            return new DouyinProvider(context, this.cache);
        }
        if (Registry.ELEME.equals((Object)type)) {
            return new ElemeProvider(context, this.cache);
        }
        if (Registry.FACEBOOK.equals((Object)type)) {
            return new FacebookProvider(context, this.cache);
        }
        if (Registry.FEISHU.equals((Object)type)) {
            return new FeishuProvider(context, this.cache);
        }
        if (Registry.GITEE.equals((Object)type)) {
            return new GiteeProvider(context, this.cache);
        }
        if (Registry.GITHUB.equals((Object)type)) {
            return new GithubProvider(context, this.cache);
        }
        if (Registry.GITLAB.equals((Object)type)) {
            return new GitlabProvider(context, this.cache);
        }
        if (Registry.GOOGLE.equals((Object)type)) {
            return new GoogleProvider(context, this.cache);
        }
        if (Registry.HUAWEI.equals((Object)type)) {
            return new HuaweiProvider(context, this.cache);
        }
        if (Registry.JD.equals((Object)type)) {
            return new JdProvider(context, this.cache);
        }
        if (Registry.KUJIALE.equals((Object)type)) {
            return new KujialeProvider(context, this.cache);
        }
        if (Registry.LINE.equals((Object)type)) {
            return new LineProvider(context, this.cache);
        }
        if (Registry.LINKEDIN.equals((Object)type)) {
            return new LinkedinProvider(context, this.cache);
        }
        if (Registry.MEITUAN.equals((Object)type)) {
            return new MeituanProvider(context, this.cache);
        }
        if (Registry.MI.equals((Object)type)) {
            return new MiProvider(context, this.cache);
        }
        if (Registry.MICROSOFT_CN.equals((Object)type)) {
            return new MicrosoftCnProvider(context, this.cache);
        }
        if (Registry.MICROSOFT.equals((Object)type)) {
            return new MicrosoftProvider(context, this.cache);
        }
        if (Registry.OKTA.equals((Object)type)) {
            return new OktaProvider(context, this.cache);
        }
        if (Registry.OSCHINA.equals((Object)type)) {
            return new OschinaProvider(context, this.cache);
        }
        if (Registry.PINTEREST.equals((Object)type)) {
            return new PinterestProvider(context, this.cache);
        }
        if (Registry.PROGINN.equals((Object)type)) {
            return new ProginnProvider(context, this.cache);
        }
        if (Registry.QQ.equals((Object)type)) {
            return new QqProvider(context, this.cache);
        }
        if (Registry.RENREN.equals((Object)type)) {
            return new RenrenProvider(context, this.cache);
        }
        if (Registry.SLACK.equals((Object)type)) {
            return new SlackProvider(context, this.cache);
        }
        if (Registry.STACK_OVERFLOW.equals((Object)type)) {
            return new StackOverflowProvider(context, this.cache);
        }
        if (Registry.TAOBAO.equals((Object)type)) {
            return new TaobaoProvider(context, this.cache);
        }
        if (Registry.TEAMBITION.equals((Object)type)) {
            return new TeambitionProvider(context, this.cache);
        }
        if (Registry.TOUTIAO.equals((Object)type)) {
            return new ToutiaoProvider(context, this.cache);
        }
        if (Registry.TWITTER.equals((Object)type)) {
            return new TwitterProvider(context, this.cache);
        }
        if (Registry.WECHAT_EE.equals((Object)type)) {
            return new WeChatEeQrcodeProvider(context, this.cache);
        }
        if (Registry.WECHAT_EE_QRCODE_THIRD.equals((Object)type)) {
            return new WeChatEeThirdQrcodeProvider(context, this.cache);
        }
        if (Registry.WECHAT_EE_WEB.equals((Object)type)) {
            return new WeChatEeWebProvider(context, this.cache);
        }
        if (Registry.WECHAT_MP.equals((Object)type)) {
            return new WeChatMpProvider(context, this.cache);
        }
        if (Registry.WECHAT_OPEN.equals((Object)type)) {
            return new WeChatOpenProvider(context, this.cache);
        }
        if (Registry.WEIBO.equals((Object)type)) {
            return new WeiboProvider(context, this.cache);
        }
        if (Registry.XIMALAYA.equals((Object)type)) {
            return new XimalayaProvider(context, this.cache);
        }
        throw new InternalException(ErrorCode.UNSUPPORTED.getDesc());
    }
}

