/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.sensitive;

import jakarta.annotation.Resource;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.stream.Collectors;
import org.miaixz.bus.base.advice.BaseAdvice;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.crypto.Builder;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.sensitive.magic.annotation.Sensitive;
import org.miaixz.bus.starter.sensitive.SensitiveProperties;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;

public class RequestBodyAdvice
extends BaseAdvice
implements org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice {
    @Resource
    SensitiveProperties properties;

    public boolean supports(MethodParameter parameter, Type type, Class<? extends HttpMessageConverter<?>> converterType) {
        Object[] annotations = parameter.getDeclaringClass().getAnnotations();
        if (ArrayKit.isNotEmpty((Object[])annotations)) {
            for (Object annotation : annotations) {
                if (!(annotation instanceof Sensitive)) continue;
                return true;
            }
        }
        return parameter.getMethod().isAnnotationPresent(Sensitive.class);
    }

    public HttpInputMessage beforeBodyRead(HttpInputMessage inputMessage, MethodParameter parameter, Type type, Class<? extends HttpMessageConverter<?>> converterType) {
        if (ObjectKit.isNotEmpty((Object)this.properties) && !this.properties.isDebug()) {
            try {
                Sensitive sensitive = parameter.getMethod().getAnnotation(Sensitive.class);
                if (ObjectKit.isEmpty((Object)sensitive)) {
                    return inputMessage;
                }
                if ("ALL".equals(sensitive.value()) || "SAFE".equals(sensitive.value()) && ("ALL".equals(sensitive.stage()) || "IN".equals(sensitive.stage()))) {
                    inputMessage = new InputMessage(this, inputMessage, this.properties.getDecrypt().getKey(), this.properties.getDecrypt().getType(), "UTF-8");
                }
            }
            catch (Exception e) {
                Logger.error((String)("Internal processing failure:" + e.getMessage()), (Object[])new Object[0]);
            }
        }
        return inputMessage;
    }

    public Object afterBodyRead(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type type, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    public Object handleEmptyBody(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type type, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    class InputMessage
    implements HttpInputMessage {
        private HttpHeaders headers;
        private InputStream body;

        public InputMessage(RequestBodyAdvice this$0, HttpInputMessage inputMessage, String key, String type, String charset) throws Exception {
            String decryptBody;
            if (StringKit.isEmpty((CharSequence)key)) {
                throw new NullPointerException("Please check the request.crypto.decrypt");
            }
            this.headers = inputMessage.getHeaders();
            String content = IoKit.toUtf8Reader((InputStream)inputMessage.getBody()).lines().collect(Collectors.joining(System.lineSeparator()));
            if (content.startsWith("{")) {
                decryptBody = content;
            } else {
                StringBuilder json = new StringBuilder();
                if (!StringKit.isEmpty((CharSequence)(content = content.replaceAll(" ", "+")))) {
                    Logger.debug((String)"Request data decryption enabled ...", (Object[])new Object[0]);
                    String[] contents = content.split("\\|");
                    for (int k = 0; k < contents.length; ++k) {
                        json.append(Builder.decrypt((String)type, (String)key, (String)contents[k], (Charset)org.miaixz.bus.core.lang.Charset.UTF_8));
                    }
                }
                decryptBody = json.toString();
            }
            this.body = IoKit.toStream((String)decryptBody, (Charset)org.miaixz.bus.core.lang.Charset.parse((String)charset));
        }

        public InputStream getBody() {
            return this.body;
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }
    }
}

