/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.sensitive;

import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.miaixz.bus.core.xyz.BooleanKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.crypto.Builder;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.mapper.handler.AbstractSqlHandler;
import org.miaixz.bus.sensitive.magic.annotation.Privacy;
import org.miaixz.bus.sensitive.magic.annotation.Sensitive;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class SensitiveResultSetHandler
extends AbstractSqlHandler
implements Interceptor {
    private boolean debug;
    private String type;
    private String key;

    public Object intercept(Invocation invocation) throws Throwable {
        List results = (List)invocation.proceed();
        if (results.isEmpty()) {
            return results;
        }
        if (this.debug) {
            ResultSetHandler statementHandler = (ResultSetHandler)SensitiveResultSetHandler.realTarget((Object)invocation.getTarget());
            MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
            MappedStatement mappedStatement = SensitiveResultSetHandler.getMappedStatement((MetaObject)metaObject, (String)"mappedStatement");
            ResultMap resultMap = mappedStatement.getResultMaps().isEmpty() ? null : (ResultMap)mappedStatement.getResultMaps().get(0);
            Sensitive sensitive = results.get(0).getClass().getAnnotation(Sensitive.class);
            if (ObjectKit.isEmpty((Object)sensitive)) {
                return results;
            }
            Map<String, Privacy> privacyMap = this.getSensitiveByResultMap(resultMap);
            for (Object object : results) {
                if ("ALL".equals(sensitive.value()) || "SAFE".equals(sensitive.value()) && ("ALL".equals(sensitive.stage()) || "OUT".equals(sensitive.stage()))) {
                    MetaObject objMetaObject = mappedStatement.getConfiguration().newMetaObject(object);
                    for (Map.Entry<String, Privacy> entry : privacyMap.entrySet()) {
                        String property;
                        String value;
                        Privacy privacy = entry.getValue();
                        if (!ObjectKit.isNotEmpty((Object)privacy) || !StringKit.isNotEmpty((CharSequence)privacy.value()) || !"ALL".equals(privacy.value()) && !"OUT".equals(privacy.value()) || !StringKit.isNotEmpty((CharSequence)(value = (String)objMetaObject.getValue(property = entry.getKey())))) continue;
                        Logger.debug((String)"Query data decryption enabled ...", (Object[])new Object[0]);
                        String decryptValue = Builder.decrypt((String)this.type, (String)this.key, (String)value, (Charset)org.miaixz.bus.core.lang.Charset.UTF_8);
                        objMetaObject.setValue(property, (Object)decryptValue);
                    }
                }
                if (!"ALL".equals(sensitive.value()) && !"SENS".equals(sensitive.value()) || !"ALL".equals(sensitive.stage()) && !"OUT".equals(sensitive.stage())) continue;
                Logger.debug((String)"Query data sensitive enabled ...", (Object[])new Object[0]);
                org.miaixz.bus.sensitive.Builder.on(object);
            }
        }
        return results;
    }

    public Object plugin(Object object) {
        if (object instanceof ResultSetHandler) {
            return Plugin.wrap((Object)object, (Interceptor)this);
        }
        return object;
    }

    public void setProperties(Properties properties) {
        this.debug = BooleanKit.toBoolean((String)properties.getProperty("debug"));
        this.key = properties.getProperty("key");
        this.type = properties.getProperty("type");
    }

    private Map<String, Privacy> getSensitiveByResultMap(ResultMap resultMap) {
        if (null == resultMap) {
            return new HashMap<String, Privacy>(16);
        }
        return this.getSensitiveByType(resultMap.getType());
    }

    private Map<String, Privacy> getSensitiveByType(Class<?> clazz) {
        HashMap<String, Privacy> sensitiveFieldMap = new HashMap<String, Privacy>(16);
        for (Field field : clazz.getDeclaredFields()) {
            Privacy sensitiveField = field.getAnnotation(Privacy.class);
            if (null == sensitiveField) continue;
            sensitiveFieldMap.put(field.getName(), sensitiveField);
        }
        return sensitiveFieldMap;
    }
}

