/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.storage;

import org.miaixz.bus.cache.metric.ExtendCache;
import org.miaixz.bus.starter.storage.StorageProperties;
import org.miaixz.bus.starter.storage.StorageProviderService;
import org.miaixz.bus.storage.cache.StorageCache;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={StorageProperties.class})
public class StorageConfiguration {
    @Bean
    public StorageProviderService storageProviderFactory(StorageProperties properties, ExtendCache extendCache) {
        return new StorageProviderService(properties, extendCache);
    }

    @Bean
    @ConditionalOnMissingBean(value={ExtendCache.class})
    @ConditionalOnProperty(name={"extend.storage.cache.type"}, havingValue="default", matchIfMissing=true)
    public ExtendCache storageCache() {
        return StorageCache.INSTANCE;
    }
}

