/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.tracer.binding.apache.cxf;

import org.apache.cxf.Bus;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.miaixz.bus.tracer.Backend;
import org.miaixz.bus.tracer.Tracer;
import org.miaixz.bus.tracer.binding.apache.cxf.interceptor.TraceRequestInInterceptor;
import org.miaixz.bus.tracer.binding.apache.cxf.interceptor.TraceRequestOutInterceptor;
import org.miaixz.bus.tracer.binding.apache.cxf.interceptor.TraceResponseInInterceptor;
import org.miaixz.bus.tracer.binding.apache.cxf.interceptor.TraceResponseOutInterceptor;

public class TraceCxfFeature
extends AbstractFeature {
    private String profile;
    private Backend backend;

    public TraceCxfFeature() {
        this(Tracer.getBackend(), "default");
    }

    TraceCxfFeature(Backend backend, String profile) {
        this.backend = backend;
        this.profile = profile;
    }

    public TraceCxfFeature(String profile) {
        this(Tracer.getBackend(), profile);
    }

    protected void initializeProvider(InterceptorProvider provider, Bus bus) {
        TraceRequestInInterceptor requestInInterceptor = new TraceRequestInInterceptor(this.backend, this.profile);
        TraceResponseInInterceptor responseInInterceptor = new TraceResponseInInterceptor(this.backend, this.profile);
        TraceRequestOutInterceptor requestOutInterceptor = new TraceRequestOutInterceptor(this.backend, this.profile);
        TraceResponseOutInterceptor responseOutInterceptor = new TraceResponseOutInterceptor(this.backend, this.profile);
        provider.getInInterceptors().add(requestInInterceptor);
        provider.getInInterceptors().add(responseInInterceptor);
        provider.getOutInterceptors().add(requestOutInterceptor);
        provider.getOutInterceptors().add(responseOutInterceptor);
        provider.getOutFaultInterceptors().add(responseOutInterceptor);
        provider.getInFaultInterceptors().add(requestInInterceptor);
    }
}

