/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.tracer.binding.apache.cxf.interceptor;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.tracer.Backend;
import org.miaixz.bus.tracer.config.TraceFilterConfig;
import org.miaixz.bus.tracer.transport.HttpHeaderTransport;

abstract class AbstractTraceOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    protected final Backend backend;
    private final HttpHeaderTransport httpSerializer;
    private final TraceFilterConfig.Channel channel;
    private String profile;

    public AbstractTraceOutInterceptor(String phase, TraceFilterConfig.Channel channel, Backend backend, String profile) {
        super(phase);
        this.channel = channel;
        this.backend = backend;
        this.profile = profile;
        this.httpSerializer = new HttpHeaderTransport();
    }

    public void handleMessage(Message message) {
        if (this.shouldHandleMessage(message)) {
            TraceFilterConfig filterConfiguration = this.backend.getConfiguration(this.profile);
            if (!this.backend.isEmpty() && filterConfiguration.shouldProcessContext(this.channel)) {
                Map<String, String> filteredParams = filterConfiguration.filterDeniedParams(this.backend.copyToMap(), this.channel);
                Logger.debug((String)"Interceptor handles message!", (Object[])new Object[0]);
                if (Boolean.TRUE.equals(message.getExchange().get((Object)"org.apache.cxf.rest.message"))) {
                    HashMap<String, List<String>> responseHeaders = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
                    if (null == responseHeaders) {
                        responseHeaders = new HashMap<String, List<String>>();
                        message.put((Object)Message.PROTOCOL_HEADERS, responseHeaders);
                    }
                    String contextAsHeader = this.httpSerializer.render(filteredParams);
                    responseHeaders.put("TPIC", Collections.singletonList(contextAsHeader));
                } else {
                    try {
                        SoapMessage responseHeaders = (SoapMessage)message;
                    }
                    catch (NoClassDefFoundError e) {
                        Logger.error((String)"Should handle SOAP-message but it seems that cxf soap dependency is not on the classpath. Unable to add Builder-Headers: {}", (Object[])new Object[]{e.getMessage(), e});
                    }
                }
            }
        }
    }

    protected abstract boolean shouldHandleMessage(Message var1);
}

