/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.tracer.binding.apache.cxf.interceptor;

import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.miaixz.bus.tracer.Backend;
import org.miaixz.bus.tracer.Builder;
import org.miaixz.bus.tracer.binding.apache.cxf.interceptor.AbstractTraceInInterceptor;
import org.miaixz.bus.tracer.config.TraceFilterConfig;

public class TraceRequestInInterceptor
extends AbstractTraceInInterceptor {
    public TraceRequestInInterceptor(Backend backend) {
        this(backend, "default");
    }

    public TraceRequestInInterceptor(Backend backend, String profile) {
        super("pre-invoke", TraceFilterConfig.Channel.IncomingRequest, backend, profile);
    }

    @Override
    public void handleMessage(Message message) {
        super.handleMessage(message);
        if (this.shouldHandleMessage(message)) {
            Builder.generateInvocationIdIfNecessary(this.backend);
        }
    }

    @Override
    protected boolean shouldHandleMessage(Message message) {
        return !MessageUtils.isRequestor((Message)message);
    }
}

