/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.tracer.binding.apache.httpclient5;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.miaixz.bus.tracer.Backend;
import org.miaixz.bus.tracer.Tracer;
import org.miaixz.bus.tracer.config.TraceFilterConfig;
import org.miaixz.bus.tracer.transport.HttpHeaderTransport;

public class TraceHttpResponseInterceptor
implements HttpResponseInterceptor {
    private final Backend backend;
    private final HttpHeaderTransport transportSerialization;
    private final String profile;

    public TraceHttpResponseInterceptor() {
        this("default");
    }

    public TraceHttpResponseInterceptor(String profile) {
        this(Tracer.getBackend(), profile);
    }

    TraceHttpResponseInterceptor(Backend backend, String profile) {
        this.backend = backend;
        this.profile = profile;
        this.transportSerialization = new HttpHeaderTransport();
    }

    public final void process(HttpResponse response, EntityDetails entityDetails, HttpContext httpContext) {
        TraceFilterConfig filterConfiguration = this.backend.getConfiguration(this.profile);
        Iterator headerIterator = response.headerIterator("TPIC");
        if (null != headerIterator && headerIterator.hasNext() && filterConfiguration.shouldProcessContext(TraceFilterConfig.Channel.IncomingResponse)) {
            ArrayList<String> stringTraceHeaders = new ArrayList<String>();
            while (headerIterator.hasNext()) {
                stringTraceHeaders.add(((Header)headerIterator.next()).getValue());
            }
            this.backend.putAll(filterConfiguration.filterDeniedParams(this.transportSerialization.parse(stringTraceHeaders), TraceFilterConfig.Channel.IncomingResponse));
        }
    }
}

