/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.tracer.binding.quartz;

import org.miaixz.bus.tracer.Backend;
import org.miaixz.bus.tracer.Tracer;
import org.miaixz.bus.tracer.config.TraceFilterConfig;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Trigger;

public class TraceContextInjector {
    private final Backend backend;
    private final String profile;

    public TraceContextInjector() {
        this(Tracer.getBackend(), "default");
    }

    public TraceContextInjector(String profile) {
        this(Tracer.getBackend(), profile);
    }

    TraceContextInjector(Backend backend, String profile) {
        this.backend = backend;
        this.profile = profile;
    }

    public void injectContext(Trigger trigger) {
        this.injectContext(trigger.getJobDataMap());
    }

    public void injectContext(JobDetail jobDetail) {
        this.injectContext(jobDetail.getJobDataMap());
    }

    public void injectContext(JobDataMap jobDataMap) {
        TraceFilterConfig configuration = this.backend.getConfiguration(this.profile);
        if (!this.backend.isEmpty() && configuration.shouldProcessContext(TraceFilterConfig.Channel.AsyncDispatch)) {
            jobDataMap.put("TPIC", this.backend.getConfiguration(this.profile).filterDeniedParams(this.backend.copyToMap(), TraceFilterConfig.Channel.AsyncDispatch));
        }
    }
}

