/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.tracer.binding.servlet;

import jakarta.servlet.annotation.WebListener;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import org.miaixz.bus.tracer.Backend;
import org.miaixz.bus.tracer.Builder;
import org.miaixz.bus.tracer.Tracer;

@WebListener(value="TraceSessionListener to create sessionIds on session creation and remove it instead from the Builder backend on session termination.")
public class TraceSessionListener
implements HttpSessionListener {
    private final Backend backend;

    public TraceSessionListener() {
        this(Tracer.getBackend());
    }

    protected TraceSessionListener(Backend backend) {
        this.backend = backend;
    }

    public final void sessionCreated(HttpSessionEvent httpSessionEvent) {
        Builder.generateSessionIdIfNecessary(this.backend, httpSessionEvent.getSession().getId());
    }

    public final void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        this.backend.remove("TPIC.sessionId");
    }
}

