/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.tracer.binding.spring.amqp;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Envelope;
import java.util.HashMap;
import java.util.Map;
import org.miaixz.bus.tracer.Backend;
import org.miaixz.bus.tracer.Builder;
import org.miaixz.bus.tracer.Tracer;
import org.miaixz.bus.tracer.config.TraceFilterConfig;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.support.DefaultMessagePropertiesConverter;

public class TraceMessagePropertiesConverter
extends DefaultMessagePropertiesConverter {
    private final Backend backend;
    private final String profile;

    public TraceMessagePropertiesConverter() {
        this(Tracer.getBackend(), "default");
    }

    public TraceMessagePropertiesConverter(String profile) {
        this(Tracer.getBackend(), profile);
    }

    TraceMessagePropertiesConverter(Backend backend, String profile) {
        this.backend = backend;
        this.profile = profile;
    }

    public MessageProperties toMessageProperties(AMQP.BasicProperties source, Envelope envelope, String charset) {
        Map<String, String> traceContextMap;
        MessageProperties messageProperties = super.toMessageProperties(source, envelope, charset);
        TraceFilterConfig filterConfiguration = this.backend.getConfiguration(this.profile);
        if (filterConfiguration.shouldProcessContext(TraceFilterConfig.Channel.AsyncProcess) && null != (traceContextMap = this.transformToTraceContextMap((Map)messageProperties.getHeaders().get("TPIC"))) && !traceContextMap.isEmpty()) {
            this.backend.putAll(filterConfiguration.filterDeniedParams(traceContextMap, TraceFilterConfig.Channel.AsyncProcess));
        }
        Builder.generateInvocationIdIfNecessary(this.backend);
        return messageProperties;
    }

    private Map<String, String> transformToTraceContextMap(Map<String, ?> tpicMessageHeader) {
        HashMap<String, String> TraceContext = new HashMap<String, String>();
        if (null != tpicMessageHeader) {
            for (Map.Entry<String, ?> stringObjectEntry : tpicMessageHeader.entrySet()) {
                TraceContext.put(stringObjectEntry.getKey(), String.valueOf(stringObjectEntry.getValue()));
            }
        }
        return TraceContext;
    }

    public AMQP.BasicProperties fromMessageProperties(MessageProperties source, String charset) {
        TraceFilterConfig filterConfiguration = this.backend.getConfiguration(this.profile);
        if (!this.backend.isEmpty() && filterConfiguration.shouldProcessContext(TraceFilterConfig.Channel.AsyncDispatch)) {
            Map<String, String> filteredParams = filterConfiguration.filterDeniedParams(this.backend.copyToMap(), TraceFilterConfig.Channel.AsyncDispatch);
            source.getHeaders().put("TPIC", filteredParams);
        }
        return super.fromMessageProperties(source, charset);
    }
}

